/*********************************************************************************
* C++ Implementation: kbearlocaldirlister.cpp
* Description:
*                              
* Begin : lr feb 16 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdir.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kdirlister.h>
#include <kio/netaccess.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kfileitem.h>
#include <klargefile.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearlocaldirlister.h"

#include "kbearlocaldirlister.moc"

using namespace KBear;
//-----------------------------------------------
KBearLocalDirLister::KBearLocalDirLister( QWidget* parent )
	: KBearDirListerIface( parent ), m_dirLister( new KDirLister( true ) )
{
	m_dirLister->setAutoUpdate( true );
	connect( m_dirLister, SIGNAL( started( const KURL& ) ), SIGNAL( started() ) );
	connect( m_dirLister, SIGNAL( completed() ), SIGNAL(finishedLoading() ) );
	connect( m_dirLister, SIGNAL( canceled() ), SIGNAL(finishedLoading() ) );
	connect( m_dirLister, SIGNAL( percent( int ) ), SIGNAL( progress( int ) ) );
	connect( m_dirLister, SIGNAL( speed(int) ), SIGNAL( speed(int) ) );
	connect( m_dirLister, SIGNAL( newItems( const KFileItemList &) ), SIGNAL( newItems( const KFileItemList &) ) );
	connect( m_dirLister, SIGNAL( refreshItems( const KFileItemList &) ), SIGNAL( refreshItems( const KFileItemList &) ) );
	connect( m_dirLister, SIGNAL( deleteItem( KFileItem* ) ), SIGNAL( deleteItem( KFileItem* ) ) );
	connect( m_dirLister, SIGNAL( redirection( const KURL& ) ),SIGNAL( redirection( const KURL& ) ) );
	connect( m_dirLister, SIGNAL( redirection( const KURL&, const KURL& ) ),SIGNAL( redirection( const KURL&, const KURL& ) ) );
	connect( m_dirLister, SIGNAL( clear() ), SIGNAL( clear() ) );
	connect( m_dirLister, SIGNAL( infoMessage( const QString& ) ), SIGNAL( infoMessage( const QString& ) ) );

}
//-----------------------------------------------
KBearLocalDirLister::~KBearLocalDirLister() {
	if( m_dirLister ) {
		delete m_dirLister;
	}
}
//-----------------------------------------------
void KBearLocalDirLister::openConnection() {
	emit connected();
//	statURL( QDir::homeDirPath() );
}
//-----------------------------------------------
void KBearLocalDirLister::openURL( const KURL& url, bool reload ) {
	m_url = url;
	m_dirLister->openURL( url, false, reload );
}
//-----------------------------------------------
void KBearLocalDirLister::getMimetype( const KURL& url ) {
	statURL( url );
}
//-----------------------------------------------
void KBearLocalDirLister::statURL( const KURL& url, bool statingLink ) {
	m_lastMimeType = QString::null;
	QCString path( QFile::encodeName( url.path() ) );
	KDE_struct_stat buff;
	if( statingLink ) {
		if( KDE_lstat( path.data(), &buff ) == -1 ) {
			// error during stat, no search permissions for specified path ?
			// TODO Warn user
			return;
		}
	}
	else {
		if( KDE_stat( path.data(), &buff ) == -1 ) {
			// error during stat, no search permissions for specified path ?
			// TODO Warn user
			return;
		}
	}
	if( S_ISLNK( buff.st_mode ) ) { // we follow the link recursively
		statURL( url, true );
		return;
	}
	m_lastMimeType = KMimeType::findByURL( url, buff.st_mode, true )->name();
	if( S_ISDIR( buff.st_mode ) ) { // is it a directory ?
		emit openDir( url );
	}
	else if( S_ISREG( buff.st_mode ) ) { // is it a file ?
		emit openFile( url );
	}
	else { // nothing we can open ?
		m_lastMimeType = QString::null;
		// TODO Warn user
	}
}
//-----------------------------------------------
void KBearLocalDirLister::stop() {
	m_dirLister->stop();
}
//-----------------------------------------------
void KBearLocalDirLister::mkdir( const KURL& newDir ) {
	KIO::NetAccess::mkdir( newDir );
}
//-----------------------------------------------
void KBearLocalDirLister::deleteFiles( const KURL::List urls, bool shred, bool showProgress ) {
	/*KIO::Job* job =*/(void) KIO::del( urls, shred, showProgress );

/*
	connect( job, SIGNAL( result( KIO::Job*) ), SIGNAL( deleteFinished() ) );
	KURL::List::ConstIterator it = urls.begin();
	for( ; it != urls.end(); ++it )
		emit deleteItem( new KFileItem( KFileItem::Unknown, KFileItem::Unknown, (*it) ) );
*/
}
//-----------------------------------------------
void KBearLocalDirLister::setNameFilter(const QString& filter) {
	m_dirLister->setNameFilter( filter );
	m_dirLister->emitChanges();
}
//-----------------------------------------------
void KBearLocalDirLister::setShowingDotFiles( bool show ) {
	m_dirLister->setShowingDotFiles( show );
	m_dirLister->emitChanges();
}
//-----------------------------------------------
bool KBearLocalDirLister::showingDotFiles() const {
	return m_dirLister->showingDotFiles();
}
//-----------------------------------------------
void KBearLocalDirLister::slotRename( const KURL& oldURL, const KURL& newURL ) {
	KIO::SimpleJob* job = KIO::rename( oldURL, newURL, false );
	job->setAutoErrorHandlingEnabled( true, (QWidget*)parent() );
}
//-----------------------------------------------
