/*********************************************************************************
* C++ Implementation: kbearlocalfilesyspart.cpp
* Description:
*                              
* Begin : lr feb 09 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstringlist.h>
#include <qlabel.h>
#include <qvaluelist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/genericfactory.h>
#include <kparts/partmanager.h>
#include <kservice.h>
#include <kaboutdata.h>
#include <kmessagebox.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <krun.h>
#include <klocale.h>
#include <kfileview.h>
#include <kfileitem.h>
#include <kinstance.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <kpropertiesdialog.h>

#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearlocalfilesyspart.h"
#include "kbearfilesyswidget.h"
#include "kbearapi.h"
#include "kbearcore.h"
#include "kbearapi.h"
#include "kbeardirview.h"
#include "kbearlocaldirlister.h"
#include "kbeardetailview.h"
#include "kbeariconview.h"



#include "kbearlocalfilesyspart.moc"

using namespace KBear;
//-----------------------------------------------
typedef KParts::GenericFactory<KBearLocalFileSysPart> KBearLocalFileSysPartFactory;
K_EXPORT_COMPONENT_FACTORY( libkbearlocalfilesyspart, KBearLocalFileSysPartFactory );
//-----------------------------------------------
KBearLocalFileSysPart::KBearLocalFileSysPart( QWidget* parentWidget, const char* widgetName, QObject* parent, const char* name, const QStringList& )
	:	KBearFileSysPartInterface( parentWidget, widgetName, parent, name )
  
{
	// we need an instance
	setInstance( KBearLocalFileSysPartFactory::instance() );
	KGlobal::locale()->insertCatalogue("kbear");

	setupActions();
	setXMLFile("kbearlocalfilesyspart.rc", true, true );

	m_myWidget->setDirLister( new KBearLocalDirLister( m_myWidget ) );
}
//-----------------------------------------------
KBearLocalFileSysPart::~KBearLocalFileSysPart() {
}
//-----------------------------------------------
void KBearLocalFileSysPart::setupActions(){
	m_shredAction = new KAction( i18n("&Shred"), "shredder", CTRL+SHIFT+Key_Delete, this, SLOT( slotShred() ), actionCollection(), "edit_shred" );
	m_shredAction->setEnabled( false );
}
//-----------------------------------------------
void KBearLocalFileSysPart::slotProperties() {
	if ( m_myWidget->fileView() ) {
		const KFileItemList *list = m_myWidget->fileView()->selectedItems();
		if( ! list->isEmpty() ) {
			(void) new KPropertiesDialog( *list, widget(), "props dlg", true );
		}
	}
}
//-----------------------------------------------
KAboutData* KBearLocalFileSysPart::createAboutData() {
	KAboutData* about = new KAboutData( "kbearlocalfilesyspart", I18N_NOOP("KBearLocalFileSysPart"), "1.0", 0,
							KAboutData::License_GPL, I18N_NOOP("(C) 2003, The KBear team") );
	about->addAuthor("Björn Sahlström", 0, "kbjorn@users.sourceforge.net");

	return about;
}
//-----------------------------------------------
void KBearLocalFileSysPart::openWith( const KURL::List& urlList ) {
	KRun::displayOpenWithDialog( urlList, false );
}
//-----------------------------------------------
void KBearLocalFileSysPart::executeService( const QString& exec, const KURL::List& urlList, const QString& name, const QString& icon ) {
	KRun::run( exec, urlList, name, icon );
}
//-----------------------------------------------
void KBearLocalFileSysPart::slotShred() {
	m_myWidget->deleteSelectedItems( true );
}
//-----------------------------------------------
KBearDirView* KBearLocalFileSysPart::createTreeView( QWidget* parent, const SiteInfo& info ) {
	KBearDirView* view = new KBearDirView( parent, "DirView", info );
	connect( view, SIGNAL(dropped( QMimeSource*, const QPoint& )),
				this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
	return view;
}
//-----------------------------------------------
KFileView* KBearLocalFileSysPart::createView( QWidget* parent, KFile::FileView view ) {
	m_viewActionCollection = 0;
	KFileView* newView = 0L;
	if((view & KFile::Simple) == KFile::Simple ) {
		newView = new KBearIconView( parent, "simple view", m_siteInfo);
		connect( static_cast<KBearIconView*>(newView), SIGNAL(dropped( QMimeSource*, const QPoint& )),
					this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
		connect( static_cast<KBearIconView*>(newView), SIGNAL(selectionChanged()),
					this,SLOT(slotSelectionChanged()));
		connect( static_cast<KBearIconView*>(newView), SIGNAL(rename( const KURL&, const KURL& )),
					m_myWidget->dirLister(),SLOT(slotRename( const KURL&, const KURL& )));
	}
	else {
		newView = new KBearDetailView( parent, "detail view", m_siteInfo);
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(dropped( QMimeSource*, const QPoint& )),
					this,SLOT( slotDropped(QMimeSource*, const QPoint&)));
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(selectionChanged()),
					this,SLOT(slotSelectionChanged()));
		connect( static_cast<KBearDetailView*>(newView), SIGNAL(rename( const KURL&, const KURL& )),
					m_myWidget->dirLister(),SLOT(slotRename( const KURL&, const KURL& )));
	}
	newView->widget()->hide();
	return newView;
}
//-----------------------------------------------
void KBearLocalFileSysPart::slotSetupPopupMenu() {
	KFileView* fileView = m_myWidget->fileView();
	if( ! m_actionMenu || ! fileView )
		return;

	bool hasSelection = fileView && fileView->selectedItems() && ! fileView->selectedItems()->isEmpty();
	m_actionMenu->clear();
	action( KStdAction::name(KStdAction::Up) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Back) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Forward) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Home) )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Redisplay))->plug( m_actionMenu );
	action( "view_stop" )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( "edit_mkdir" )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( "edit_rename" )->plug( m_actionMenu );
	action( "edit_delete" )->plug( m_actionMenu );
	m_shredAction->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Cut) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Copy) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Paste) )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Find) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::FindNext) )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::SelectAll) )->plug( m_actionMenu );
	action( KStdAction::name(KStdAction::Deselect) )->plug( m_actionMenu );
	action( "edit_invert_selection" )->plug( m_actionMenu );
	action( "separator" )->plug( m_actionMenu );
	if( hasSelection ) {
		m_openEditorAction->plug( m_actionMenu );
		action( "separator" )->plug( m_actionMenu );
		if( m_myWidget->fileView()->selectedItems()->count() == 1 && setupOpenWithMenu()>0 ) {
			action( "openWithMenu" )->plug( m_actionMenu );
		}
		else {
			action("open_with")->setText( i18n("&Open With...") );
			action("open_with")->plug( m_actionMenu );
		}
		action( "separator" )->plug( m_actionMenu );
	}			
  	action( "sortActionMenu" )->plug( m_actionMenu );
 	action( "separator" )->plug( m_actionMenu );
	action( "viewActionMenu" )->plug( m_actionMenu );
 	action( "separator" )->plug( m_actionMenu );
	action( "properties" )->plug( m_actionMenu );
}
//-----------------------------------------------
