/*********************************************************************************
* C++ Interface: kbearlocalfilesyspart.h
* Description:
*                              
* Begin : lr feb 09 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARLOCALFILESYSPART_H
#define KBEARLOCALFILESYSPART_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrstack.h>
#include <qvaluelist.h>
#include <qptrlist.h>
#include <qdatetime.h>
#include <qpoint.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kaction.h>
#include <kparts/event.h>
#include <kaboutdata.h>
#include <kurl.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearfilesyspartiface.h"
#include "siteinfo.h"

class QTextCodec;
class QPopupMenu;
class KProgress;
class QTimer;
class QSplitter;
class KComboBox;
class KHistoryCombo;
class QLabel;
class KBearLocalDirLister;

/**
	* 
	* @author Bjrn Sahlstrm
	**/
class KBearLocalFileSysPart : public KBear::KBearFileSysPartInterface {
	Q_OBJECT
public:
		/** */
	KBearLocalFileSysPart( QWidget* parentWidget, const char* widgetName, 	QObject* parent, const char* name, const QStringList& = QStringList() );
		/** */
	~KBearLocalFileSysPart();
	/** */
	static KAboutData* createAboutData();
	/**
	* @return if the part works against a local file system.
	*/
	virtual bool isLocal() const { return true; };
	/** */
	virtual QString fromUnicode( const QString& str ) { return str; }
	/** */
	virtual QString toUnicode( const QString& str ) { return str; }
	/** No descriptions */
	virtual void openWith( const KURL::List& );
protected slots:
	/** */
	void slotShred();
	/** */
	virtual void slotSetupPopupMenu();
	/** */
	virtual void slotProperties();
protected:
	/** No descriptions */
	virtual void executeService( const QString& exec, const KURL::List& urlList, const QString& name, const QString& icon );
	/**
	* A view factory for creating predefined fileviews.
	*/
	virtual KBear::KBearDirView* createTreeView( QWidget* parent, const KBear::SiteInfo& info );
	/**
	* A view factory for creating predefined fileviews.
	*/
	virtual KFileView* createView( QWidget* parent, KFile::FileView view );
private:
	/** */
	void setupActions();
protected:
	KAction* m_shredAction;
	KBearLocalDirLister* m_dirLister;
};

#endif
