/*********************************************************************************
* C++ Interface: kbearremotedirlister.h
* Description:
*                              
 Begin : ons feb 26 2003
** Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARREMOTEDIRLISTER_H
#define KBEARREMOTEDIRLISTER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
#include <qregexp.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeardirlisteriface.h"

using namespace KBear;

/**
 * 
 * Bjrn Sahlstrm
 **/
class KBearRemoteDirLister : public KBearDirListerIface {
	Q_OBJECT
public:
	/** */
	KBearRemoteDirLister( QWidget* parent );
	/** */
	virtual bool isLocal() const { return false; }
	/** */
	~KBearRemoteDirLister();
	/** */
	virtual void openConnection();
	/** */
	virtual void closeConnection();
	/** */
	virtual void openURL( const KURL& url, bool reload = false );
	/** */
	virtual void statURL( const KURL& url, bool statingLink = false );
	/** */
	virtual void getMimetype( const KURL& url );
	/** */
	virtual void setShowingDotFiles( bool );
	/** */
	virtual void stop();
	/** */
	virtual void mkdir( const KURL& newDir );
	/** */
	virtual void deleteFiles( const KURL::List urls, bool shred, bool showProgress );
	/** */
	virtual void setNameFilter(const QString& filter);
	/** */
	virtual bool showingDotFiles() const;
	/***/
	virtual QString lastMimeType() const{ return m_lastMimeType; }
public slots:
	/** */
	virtual void slotRename( const KURL& oldURL, const KURL& newURL );
private slots:
	void slotConnected( int );
	void slotNotConnected( int );
	void slotEntries( KIO::Job* job, const KIO::UDSEntryList& entryList );
	void slotPercent( KIO::Job*, unsigned long pcnt );
	void slotSpeed( KIO::Job*, unsigned long speed );
	void slotInfoMessage( const QString& message );
	void slotMimetype( KIO::Job* job, const QString& mime );
	void slotResult( KIO::Job* );
	void slotError( int ID, int err, const QString& errMsg );
private:
	bool matchesNameFilter( const QString& name ) const;
private:
	/** this enum specify different states for the dirlister
	these states can be OR:ed together but is usually used separate
	*/
	enum State {
		DISCONNECTED = 1,
		CONNECTING = 2,
		CONNECTED = 4,
		LISTING = 8,
		STATING = 16,
		GETTING_MIME = 32,
		MAKING_DIR = 64,
		DELETING = 128,
		RENAMING = 256
	};
	bool m_showingDotFiles;
	bool m_useFilter;
	QPtrList<QRegExp> m_filterList;
	unsigned int m_state;
	KURL m_statURL;
	QGuardedPtr<KIO::Job> m_currentJob;
};

#endif
