/*********************************************************************************
* C++ Interface: pluginmanager.h
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qdict.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kservice.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearpluginmanageriface.h"

class KWizard;
class KDialogbase;
namespace KBear{
	class KBearPlugin;
};


/**
	* 
	* @author Bjrn Sahlstrm
	**/
class PluginManager : public KBear::KBearPluginManagerInterface {
	Q_OBJECT
public:
	/** */
	~PluginManager();
	/** */
	static PluginManager* getInstance();
	/** */
	virtual void loadPlugins( bool initializePlugins = false );
	/** */
	virtual void addPlugin( KBear::KBearPlugin* client );
	/** */
	virtual void removePlugin( KBear::KBearPlugin* client );
private slots:
	void slotConfigWidget( KDialogBase* );
	void slotConfigWidget( KWizard* );
	void slotLoadPlugins();
	void slotUnloadPlugins();
private:
	KBear::KBearPlugin* loadPlugin( const KService::Ptr& service );
	bool queryUnload( const QString& warning );
	PluginManager();
private:
	static PluginManager* s_instance;
	QDict<KBear::KBearPlugin> m_plugins;
};

#endif
