/*********************************************************************************
* C++ Implementation: kbearfilediffplugin..cpp
* Description:
*
* Begin : tis jul 1 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qframe.h>
#include <qdir.h>
#include <qlayout.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/part.h>
#include <klocale.h>
#include <klibloader.h>
#include <kinstance.h>
#include <kiconloader.h>
#include <kgenericfactory.h>
#include <kstatusbar.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
#include <assert.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearconsoleplugin.h"
#include "kbearmainwiniface.h"



using namespace KBear;

#include "kbearconsoleplugin.moc"
//-----------------------------------------------
typedef KGenericFactory<KBearConsolePlugin> KBearConsolePluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearconsole, KBearConsolePluginFactory( "kbearconsole" ) );
//-----------------------------------------------
KBearConsolePlugin::KBearConsolePlugin(QObject *parent, const char*, const QStringList& )
  : KBearPlugin( parent, "KBearConsolePlugin" )
{
	setInstance(KBearConsolePluginFactory::instance());

	m_outputWidget = new QWidget( 0L, "KBearConsoleOutputWidget" );
	QVBoxLayout* vbox = new QVBoxLayout( m_outputWidget );

	KLibFactory *factory = KLibLoader::self()->factory("libkonsolepart");

	assert( factory );

	KParts::ReadOnlyPart* part = static_cast<KParts::ReadOnlyPart*>( factory->create( m_outputWidget ) );

	assert( part );

	part->widget()->setFocusPolicy( QWidget::WheelFocus );
	m_outputWidget->setFocusProxy(part->widget());
	part->widget()->setFocus();

	if( part->widget()->inherits("QFrame") )
		((QFrame*)part->widget())->setFrameStyle(QFrame::Panel|QFrame::Sunken);

	vbox->addWidget( part->widget() );

	part->widget()->show();

}
//-----------------------------------------------
KBearConsolePlugin::~KBearConsolePlugin() {
	mainWindow()->removeOutputPluginView( m_outputWidget );
	delete m_outputWidget;
}
//-----------------------------------------------
void KBearConsolePlugin::slotInit() {
	mainWindow()->embedOutputPluginView( m_outputWidget, i18n( "Console" ), i18n( "Embedded console" ) );
}
//-----------------------------------------------
