/*********************************************************************************
* C++ Interface: filediffdropwidget.h
* Description:
*
* Begin : ons jun 18 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef FILEDIFFDROPWIDGET_H
#define FILEDIFFDROPWIDGET_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <ksqueezedtextlabel.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

/**
@author Bjrn Sahlstrm
*/
class FileDiffDropWidget : public KSqueezedTextLabel {
	Q_OBJECT
public:
	/** */
	enum Type{ Source, Destination };
		/** */
	FileDiffDropWidget( const QString& text, Type type, QWidget* parent, const char* name );
	/** */
	~FileDiffDropWidget();
	/** */
	unsigned int type() const { return m_type; }
	/** */
	void setFileName( const QString& file );
	/** */
	QString getFileName() const { return m_file; }
	/** */
	void clear();
signals:
	void dropped( QDropEvent* e );
public slots:
	void slotProgress( long, unsigned long );
protected: //Protected Methods
	/**  */
	virtual void dragMoveEvent( QDragMoveEvent *e );
	/**  */
	virtual void dropEvent( QDropEvent* e );
	/**
	* @return true if we can decode the drag and support the action
	*/
	bool acceptDrag(QDropEvent* event) const;
private:
	Type m_type;
	QString m_file;
	QString m_text;
};

#endif
