/*********************************************************************************
* C++ Interface: kbearfilediffplugin..h
* Description:
*
* Begin : ons jun 18 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef __KBEARFILEDIFFPLUGIN_H__
#define __KBEARFILEDIFFPLUGIN_H__

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qstringlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kurl.h>
#include <kio/global.h>
#include <kparts/part.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearplugin.h"
#include "filediffdropwidget.h"

class QFrame;
class QWidget;
class KTempFile;
class KProcess;
class KBearDiffTextEdit;
class QPopupMenu;
class KAction;
class KToggleAction;

namespace KBear {
	class Transfer;
};

class KBearFileDiffPlugin : public KBear::KBearPlugin {
	Q_OBJECT
public:
	/** */
	KBearFileDiffPlugin(QObject* parent, const char* name, const QStringList& args = QStringList());
	/** */
	virtual ~KBearFileDiffPlugin();
public slots:
	/** */
	virtual void slotInit();
private slots:
	void slotSourceDrop( QDropEvent* );
	void slotDestDrop( QDropEvent* );
	void slotSourceFinished();
	void slotDestFinished();
	void slotSourceStatusChanged( long, unsigned int status );
	void slotDestStatusChanged( long, unsigned int status );
	void slotProcessExited( KProcess* );
	void slotReceivedStdout( KProcess*, char*, int );
	void slotReceivedStderr( KProcess*, char*, int );
	void slotClear();
	void slotPopupMenuRequest( QPopupMenu* );
	void slotSaveAs();
	void slotToggleSyntaxHighlight();
	void slotExternalActivated();
private:
	KBear::Transfer* newDrop( QDropEvent* drop, KURL& url, KURL& tmpURL, FileDiffDropWidget* dropZone  );
	void execDiff();
	void showDiff();
	void searchForExternalParts();
private:
	QFrame* m_separator;
	FileDiffDropWidget* m_sourceDropZone;
	FileDiffDropWidget* m_destDropZone;
	KBearDiffTextEdit* m_diffEdit;
	QWidget* m_outputWidget;
	KURL m_sourceURL;
	KURL m_destURL;
	KURL m_sourceTmpURL;
	KURL m_destTmpURL;
	KTempFile* m_diffTmpFile;
	KProcess* m_diffProcess;
	bool m_sourceFinished;
	bool m_destFinished;
	QString m_stdOut;
	QString m_stdErr;
	KAction* m_clearDiff;
	KAction* m_saveAs;
	KToggleAction* m_toggleHighlight;
	static QStringList s_externalParts;
	KParts::ReadOnlyPart* m_externalPart;
};


#endif
