/*********************************************************************************
* C++ Implementation: firewallsettingswidget.cpp
* Description:
*                              
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kcombobox.h>
#include <klineedit.h>
#include <knuminput.h>
#include <kconfig.h>
#include <kapplication.h>
#include <klocale.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <klineedit.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "firewallsettingswidget.h"
#include "misc.h"

#include "firewallsettingswidget.moc"

using namespace KBear;
//-----------------------------------------------
FirewallSettingsWidget::FirewallSettingsWidget( KConfig* config, QWidget *parent, const char *name )
	:	KBearConfigWidgetIface( parent, name ),
		m_type0Str( i18n("No firewall") ),
		m_type1Str( QString::fromLatin1("USER user@real.host.name") ),
		m_type2Str( QString::fromLatin1("USER fwuser PASS fwpassword USER user@real.host.name") ),
		m_type3Str( QString::fromLatin1("SITE real.host.name USER user PASS pass") ),
		m_type4Str( QString::fromLatin1("OPEN real.host.name USER user PASS pass") ),
		m_type5Str( QString::fromLatin1("USER user@fwuser@real.host.name PASS pass@fwpass") ),
		m_type6Str( QString::fromLatin1("USER fwuser@real.host.name PASS fwpass USER user PASS pass") ),
		m_type7Str( QString::fromLatin1("USER user@real.host.name fwuser PASS passACCT fwpass") ),
		m_type8Str( QString::fromLatin1("Special") ),
		m_config( config )
{
    setupGUI();
	 m_firewallTypeCombo->setCurrentItem( m_type0Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type1Str , true );
    m_firewallTypeCombo->setCurrentItem( m_type2Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type3Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type4Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type5Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type6Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type7Str, true );
    m_firewallTypeCombo->setCurrentItem( m_type8Str, true );

	readSettings();
}
//-----------------------------------------------
FirewallSettingsWidget::~FirewallSettingsWidget(){
}
//-----------------------------------------------
void FirewallSettingsWidget::saveSettings() {
	m_config->setGroup( QString::fromLatin1("Firewall") );
	m_config->writeEntry( QString::fromLatin1("Type"), m_firewallTypeCombo->currentItem() );
	m_config->writeEntry( QString::fromLatin1("Macro"), m_firewallSpecialText->text() );
	m_config->writeEntry( QString::fromLatin1("Host"), m_firewallHostEdit->text() );
	m_config->writeEntry( QString::fromLatin1("Port"), m_firewallPortSpinBox->value() );
	m_config->writeEntry( QString::fromLatin1("User"), m_firewallUserEdit->text() );
	QString tmp = m_firewallPassEdit->text();
	m_config->writeEntry( QString::fromLatin1("Pass"), encodePassword( tmp ) );
	m_config->writeEntry( QString::fromLatin1("Account"), m_firewallAccountEdit->text() );
	m_config->sync();
	}
//-----------------------------------------------
void FirewallSettingsWidget::readSettings( bool /*defaultSettings*/ ) {
	m_config->setGroup( QString::fromLatin1("Firewall") );
	unsigned int type = m_config->readUnsignedNumEntry( QString::fromLatin1("Type"), NONE );
	m_firewallTypeCombo->setCurrentItem( type );
	slotFirewallTypeActivated( type );
	m_firewallSpecialText->setText( m_config->readEntry( QString::fromLatin1("Macro"), QString::null ) );		
	QString tmp = m_config->readEntry( QString::fromLatin1("Host"), QString::null );
	m_firewallHostEdit->setText( tmp );
	int p = m_config->readUnsignedNumEntry( QString::fromLatin1("Port"), 21 );
	m_firewallPortSpinBox->setValue( p );
	tmp = m_config->readEntry( QString::fromLatin1("User"), QString::null );
	m_firewallUserEdit->setText( tmp );
	tmp = m_config->readEntry( QString::fromLatin1("Pass"), QString::null );
	m_firewallPassEdit->setText( decodePassword( tmp ) );
	tmp = m_config->readEntry( QString::fromLatin1("Account"), QString::null );
	m_firewallAccountEdit->setText( tmp );
}
//-----------------------------------------------
void FirewallSettingsWidget::setupGUI() {
    QGridLayout* FirewallSettingsBaseLayout = new QGridLayout( this, 1, 1, 11, 6, "FirewallSettingsBaseLayout");
//    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
//    FirewallSettingsBaseLayout->addItem( spacer, 1, 0 );
	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>If you are behind a firewall you can use this page to configure how to login. "
															"<b>Note that these settings only apply to the FTP protocol</b>, for other protocols "
															"you have to rely on the KDE settings.</p>"
															"<p>For a detailed description on how to setup this page see the KBear documentation. "
															"You can reach it through the help button below.</p>" ) );
	infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	FirewallSettingsBaseLayout->addWidget( infoLabel, 0, 0 );

    QButtonGroup* setupButtonGroup = new QButtonGroup( this, "setupButtonGroup" );
    setupButtonGroup->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, setupButtonGroup->sizePolicy().hasHeightForWidth() ) );
    setupButtonGroup->setTitle( i18n( "Setup firewall for the FTP protocol" ) );
    setupButtonGroup->setColumnLayout(0, Qt::Vertical );
    setupButtonGroup->layout()->setSpacing( 6 );
    setupButtonGroup->layout()->setMargin( 11 );
    
	 QGridLayout* setupButtonGroupLayout = new QGridLayout( setupButtonGroup->layout() );
    setupButtonGroupLayout->setAlignment( Qt::AlignTop );

    m_firewallHostLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallHostLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallHostLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallHostLabel->setEnabled( FALSE );
    m_firewallHostLabel->setText( i18n( "Firewall hostname:" ) );
    m_firewallHostLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( m_firewallHostLabel, 0, 0 );

    m_firewallHostEdit = new KLineEdit( setupButtonGroup, "m_firewallHostEdit" );
	m_firewallHostEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallHostEdit->sizePolicy().hasHeightForWidth() ) );
    m_firewallHostEdit->setEnabled( FALSE );
    QToolTip::add( m_firewallHostEdit, i18n( "Enter the hostname for the firewall here." ) );
    QWhatsThis::add( m_firewallHostEdit, i18n( "Enter the hostname to connect to when connecting to the firewall." ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallHostEdit, 0, 0, 1, 2 );

    m_firewallPortLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallPortLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallPortLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallPortLabel->setEnabled( FALSE );
    m_firewallPortLabel->setText( i18n( "Firewall port:" ) );
    m_firewallPortLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( m_firewallPortLabel, 1, 0 );

    m_firewallPortSpinBox = new KIntSpinBox( setupButtonGroup, "m_firewallPortSpinBox" );
    m_firewallPortSpinBox->setEnabled( FALSE );
    m_firewallPortSpinBox->setMaxValue( 65535 );
    m_firewallPortSpinBox->setMinValue( 1 );
    m_firewallPortSpinBox->setValue( 21 );
    QToolTip::add( m_firewallPortSpinBox, i18n( "Enter your firewall port here." ) );
    QWhatsThis::add( m_firewallPortSpinBox, i18n( "Enter your firewall port here." ) );

    setupButtonGroupLayout->addWidget( m_firewallPortSpinBox, 1, 1 );

    m_firewallUserLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallUserLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallUserLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallUserLabel->setEnabled( FALSE );
    m_firewallUserLabel->setText( i18n( "Firewall user name:" ) );
    m_firewallUserLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( m_firewallUserLabel, 2, 0 );

    m_firewallUserEdit = new KLineEdit( setupButtonGroup, "m_firewallUserEdit" );
 	m_firewallUserEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallUserEdit->sizePolicy().hasHeightForWidth() ) );
   m_firewallUserEdit->setEnabled( FALSE );
    QToolTip::add( m_firewallUserEdit, i18n( "Enter your firewall user name here." ) );
    QWhatsThis::add( m_firewallUserEdit, i18n( "Enter your firewall user name here." ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallUserEdit, 2, 2, 1, 2 );

    m_firewallPassLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallPassLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallPassLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallPassLabel->setEnabled( FALSE );
    m_firewallPassLabel->setText( i18n( "Firewall password:" ) );
    m_firewallPassLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( m_firewallPassLabel, 3, 0 );

    m_firewallPassEdit = new KLineEdit( setupButtonGroup, "m_firewallPassEdit" );
	m_firewallPassEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallPassEdit->sizePolicy().hasHeightForWidth() ) );
    m_firewallPassEdit->setEnabled( FALSE );
    m_firewallPassEdit->setEchoMode( KLineEdit::Password );
    QToolTip::add( m_firewallPassEdit, i18n( "Enter your firewall password here." ) );
    QWhatsThis::add( m_firewallPassEdit, i18n( "Enter your firewall password here." ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallPassEdit, 3, 3, 1, 2 );
    
    m_firewallAccountLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallAccountLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallAccountLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallAccountLabel->setEnabled( FALSE );
    m_firewallAccountLabel->setText( i18n( "Firewall account:" ) );
    m_firewallAccountLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( m_firewallAccountLabel, 4, 0 );

    m_firewallAccountEdit = new KLineEdit( setupButtonGroup, "m_firewallAccountEdit" );
	m_firewallAccountEdit->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallAccountEdit->sizePolicy().hasHeightForWidth() ) );
    m_firewallAccountEdit->setEnabled( FALSE );
    QToolTip::add( m_firewallAccountEdit, i18n( "Enter your firewall account here." ) );
    QWhatsThis::add( m_firewallAccountEdit, i18n( "Enter your firewall account here." ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallAccountEdit, 4, 4, 1, 2 );

    m_firewallTypeLabel = new QLabel( setupButtonGroup, "label" );
	m_firewallTypeLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallTypeLabel->sizePolicy().hasHeightForWidth() ) );
    m_firewallTypeLabel->setEnabled( TRUE );
    m_firewallTypeLabel->setText( i18n( "Firewall type:" ) );
 //   label->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallTypeLabel, 5, 5, 0, 2 );
	 
    m_firewallTypeCombo = new KComboBox( FALSE, setupButtonGroup, "m_firewallTypeCombo" );
	m_firewallTypeCombo->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallTypeCombo->sizePolicy().hasHeightForWidth() ) );
    m_firewallTypeCombo->setEnabled( TRUE );
    m_firewallTypeCombo->setMaxCount( 9 );
    m_firewallTypeCombo->setInsertionPolicy( KComboBox::AtBottom );
    m_firewallTypeCombo->setDuplicatesEnabled( FALSE );
    QToolTip::add( m_firewallTypeCombo, i18n( "Select firewall type to use here." ) );
    QWhatsThis::add( m_firewallTypeCombo, i18n( "Select firewall type to use here. If you want to specify your own login macro, select 'Special'. If you don't need to use a firewall, select 'No firewall' (default)." ) );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallTypeCombo, 6, 6, 0, 2 );

	 m_firewallSpecialText = new QTextEdit( setupButtonGroup, "m_firewallSpecialText" );
	m_firewallSpecialText->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, m_firewallSpecialText->sizePolicy().hasHeightForWidth() ) );
    QToolTip::add( m_firewallSpecialText, i18n( "Here you can create your own firewall login macro. See below for predefined macros you can use." ) );
    QWhatsThis::add( m_firewallSpecialText, i18n( "Here you can create your own firewall login macro. "
	 																					"The predefined macros shown below can be mixed with any command used for your firewall. "
																						"Each line specified here will become a command sent to the firewall during login. "
																						"For example to create the following login:\n"
																						"USER fwuser\n"
																						"PASS fwpass\n"
																						"USER user@real.host.name\n"
																						"It will look like this:\n"
																						"USER %1\n"
																						"PASS %2\n"
																						"USER %3@%4" ).arg("%fu").arg("%fp").arg("%hu").arg("%hh") );

    setupButtonGroupLayout->addMultiCellWidget( m_firewallSpecialText, 7, 7, 0, 2 );

    QLabel* label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = Firewall host (name or IP)" ).arg("%fh") );

    setupButtonGroupLayout->addMultiCellWidget( label, 8, 8, 0, 1 );
    
	 label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = Firewall port" ).arg("%fo") );

    setupButtonGroupLayout->addMultiCellWidget( label, 9, 9, 0, 1 );

    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
   label->setText( i18n( "%1 = Firewall user" ).arg("%fu") );

    setupButtonGroupLayout->addMultiCellWidget( label, 10, 10, 0, 1 );

    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = Firewall password" ).arg("%fp") );

    setupButtonGroupLayout->addMultiCellWidget( label, 11, 11, 0, 1 );

    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = Firewall Account" ).arg("%fa") );

    setupButtonGroupLayout->addMultiCellWidget( label, 12, 12, 0, 1 );


    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = host (name or IP)" ).arg("%hh") );
    label->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( label, 8, 2 );

    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = host port" ).arg("%ho") );
    label->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( label, 9, 2 );

    label = new QLabel( setupButtonGroup, "label" );
	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
    label->setText( i18n( "%1 = host user" ).arg("%hu") );
    label->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( label, 10, 2 );

    label = new QLabel( setupButtonGroup, "label" );
 	label->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, label->sizePolicy().hasHeightForWidth() ) );
   label->setText( i18n( "%1 = host password" ).arg("%hp") );
    label->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    setupButtonGroupLayout->addWidget( label, 11, 2 );

    QSpacerItem* spacer_2 = new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
    setupButtonGroupLayout->addItem( spacer_2, 1, 2 );


    FirewallSettingsBaseLayout->addWidget( setupButtonGroup, 1, 0 );

    // signals and slots connections
    connect( m_firewallTypeCombo, SIGNAL( activated(int) ), this, SLOT( slotFirewallTypeActivated(int) ) );

    // tab order
    setTabOrder( m_firewallHostEdit, m_firewallPortSpinBox );
    setTabOrder( m_firewallPortSpinBox, m_firewallUserEdit );
    setTabOrder( m_firewallUserEdit, m_firewallPassEdit );
    setTabOrder( m_firewallPassEdit, m_firewallAccountEdit );
    setTabOrder( m_firewallAccountEdit, m_firewallTypeCombo );
    setTabOrder( m_firewallTypeCombo, m_firewallSpecialText );

	 FirewallSettingsBaseLayout->activate();
}
//-----------------------------------------------
void FirewallSettingsWidget::slotFirewallTypeActivated( int type ) {
	m_firewallHostEdit->setEnabled( type );
	m_firewallPortSpinBox->setEnabled( type );
	m_firewallUserEdit->setEnabled( type );
	m_firewallPassEdit->setEnabled( type );
	m_firewallAccountEdit->setEnabled( type );
	if( type == 8 )
		m_firewallSpecialText->setEnabled( true );
	else
		m_firewallSpecialText->setEnabled( false);

	m_firewallHostLabel->setEnabled( type );
	m_firewallAccountLabel->setEnabled( type );
	m_firewallPortLabel->setEnabled( type );
	m_firewallTypeLabel->setEnabled( type );
	m_firewallPassLabel->setEnabled( type );
	m_firewallUserLabel->setEnabled( type );

}
//-----------------------------------------------


