/*********************************************************************************
* C++ Implementation: kbearfirewallplugin.cpp
* Description:
*                              
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvbox.h>
#include <qpushbutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kaction.h>
#include <kinstance.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kgenericfactory.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearfirewallplugin.h"
#include "firewallsettingswidget.h"
#include "misc.h"
#include "kbearapi.h"
#include "kbearcore.h"


#include "kbearfirewallplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearFireWallPlugin> KBearFireWallPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearfirewall, KBearFireWallPluginFactory( "kbearfirewall" ) );
//-----------------------------------------------
KBearFireWallPlugin::KBearFireWallPlugin( QObject* parent, const char* , const QStringList& )
	:	KBearPlugin( parent, "KBearFireWallPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance( KBearFireWallPluginFactory::instance() );
	connect( m_api->core(), SIGNAL( metaDataNeeded( KIO::MetaData& ) ),
						this, SLOT( slotMetaDataNeeded( KIO::MetaData& ) ) );
}
//-----------------------------------------------
KBearFireWallPlugin::~KBearFireWallPlugin() {
}
//-----------------------------------------------
void KBearFireWallPlugin::slotInit() {
}
//-----------------------------------------------
void KBearFireWallPlugin::slotConfigWidget( KDialogBase* dlg ) {
	QVBox* vbox = dlg->addVBoxPage(i18n("Firewall"), QString::null,
									KGlobal::iconLoader()->loadIcon("kbear-firewall", KIcon::NoGroup, KIcon::SizeMedium) );
	FirewallSettingsWidget* w = new FirewallSettingsWidget( KBearFireWallPluginFactory::instance()->config(), vbox, "FirewallSettingsWidget" );
	connect( dlg, SIGNAL( okClicked() ), w, SLOT( slotSaveSettings() ) );
}
//-----------------------------------------------
void KBearFireWallPlugin::slotConfigWidget( KWizard* wiz ) {
	FirewallSettingsWidget* w = new FirewallSettingsWidget( KBearFireWallPluginFactory::instance()->config(), wiz, "FirewallSettingsWidget" );
	wiz->addPage( w, i18n("Firewall") );
//	connect( wiz->finishButton(), SIGNAL( clicked() ), w, SLOT( slotSaveSettings() ) );
}
//-----------------------------------------------
void KBearFireWallPlugin::slotMetaDataNeeded( KIO::MetaData& metaData ) {
	KConfig* config = KBearFireWallPluginFactory::instance()->config();
	config->setGroup( QString::fromLatin1("Firewall") );
	unsigned int type = config->readUnsignedNumEntry( QString::fromLatin1("Type"), FirewallSettingsWidget::NONE );
	QString firewallHost = config->readEntry( QString::fromLatin1("Host"), QString::null );
	int firewallPort = config->readUnsignedNumEntry( QString::fromLatin1("Port"), 21 );
	QString firewallUser = config->readEntry( QString::fromLatin1("User"), QString::null );
	QString firewallPass = decodePassword( config->readEntry( QString::fromLatin1("Pass"), QString::null ) );
	QString firewallAccount = config->readEntry( QString::fromLatin1("Account"), QString::null );
	QString firewallMacro = QString::null;
	if( type == FirewallSettingsWidget::TYPE_EIGHT )
		firewallMacro = config->readEntry( QString::fromLatin1("Macro"), QString::null );
	
	metaData.insert( "FirewallType", QString::number( type ) );
	if( ! firewallHost.isEmpty() )
		metaData.insert( "FirewallHost", firewallHost );
	if( firewallPort > 0 )
		metaData.insert( "FirewallPort", QString::number( firewallPort ) );
	if( ! firewallUser.isEmpty() )
		metaData.insert( "FirewallUser", firewallUser );
	if( ! firewallPass.isEmpty() )
		metaData.insert( "FirewallPass", firewallPass );
	if( ! firewallAccount.isEmpty() )
		metaData.insert( "FirewallAccount", firewallAccount );
	if( type == 8 && ! firewallMacro.isEmpty() ) // Special
		metaData.insert( "FirewallMacro", firewallMacro );
	else
		metaData[ "FirewallType" ] = FirewallSettingsWidget::NONE;
}
//-----------------------------------------------

