/*********************************************************************************
* C++ Implementation: urllistimportfilterplugin.cpp
* Description:
*
* Begin : Tue May 27 2003
* Author : Frithjof Engel <frithjof_engel@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qfile.h>
#include <qdir.h>
#include <qmap.h>
#include <qdom.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "urllistimportfilterplugin.h"
#include "kbeartags.h"
#include "misc.h"

#include "urllistimportfilterplugin.moc"

using namespace KBear;

struct UrlListImportConnectInfo{
	QString label;
	QString protocol;
	QString host;
	int port;
	bool anonym;
	QString user;
	QString pass;
	QString remotePath;
};

///////////////////////////////////////////////////////
inline QTextStream& operator >> ( QTextStream& s, UrlListImportConnectInfo& inf ) {
	QString str = s.readLine();
	KURL url( str );
	if( url.isMalformed() ) {
		KMessageBox::error( 0, i18n("Invalid URL: %1").arg( url.prettyURL() ) );
		return s;
	}
	// TODO: support other protocols
	inf.protocol = url.protocol();
	if( url.hasUser() && url.user() != "anonymous" ) {
		inf.user = url.user();
		inf.anonym = false;
	} else {
		inf.user = "anonymous";
		inf.anonym = true;
	}
	if( url.hasPass() )
		inf.pass = url.pass();
	else
		inf.pass = "anonymous@";
	if( !url.hasHost() ) {
		KMessageBox::error( 0, i18n("Invalid URL: %1\nIt does not have a host.").arg( url.prettyURL() ) );
		return s;
	} else
		inf.host = url.host();
	if( url.port() != 0 )
		inf.port = url.port();
	else
		inf.port = getPortForProtocol( inf.protocol );
	if( url.path() != QString::null )
		inf.remotePath = url.path();
	inf.label = inf.host;
	return s;
}
///////////////////////////////////////////////////////
typedef KGenericFactory<UrlListImportFilterPlugin> UrlListImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearurllistimportfilter, UrlListImportFilterPluginFactory( "UrlListImportFilterPlugin" ) );
//-----------------------------------------------
UrlListImportFilterPlugin::UrlListImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
	KGlobal::locale()->insertCatalogue("kbear");
	m_domDocument.setContent( QString("<%1 %2=\"%3\"/>").arg(TAG_GROUP).arg(ATT_LABEL).
		arg(i18n("URL List import")) );
}
//-----------------------------------------------
UrlListImportFilterPlugin::~UrlListImportFilterPlugin(){
}
//-----------------------------------------------
QString UrlListImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void UrlListImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	QFile file( fileName );
	file.open(IO_ReadOnly);
	QTextStream stream( &file );
	UrlListImportConnectInfo info;
	while( !stream.atEnd() ) {
		stream >> info;
 		addSite( info );
	}
	int answer = KMessageBox::questionYesNo( 0, i18n("The URL list has now been imported.\n"
						"Do you want to remove the URL list file now ?"), i18n("Remove file") );
	if( answer == KMessageBox::Yes ) {
		file.remove();
	}
	emit progress( 100 );
}
//-----------------------------------------------
bool UrlListImportFilterPlugin::addSite( UrlListImportConnectInfo Inf ) {
	QDomNodeList list = m_domDocument.documentElement().childNodes();
	for( unsigned int i = 0; i < list.count(); i++ ) {
		if( list.item( i ).toElement().attribute(ATT_LABEL) == Inf.label )
			return false; // site already exists
	}
	if( Inf.host.isNull() || Inf.host.isEmpty() )
		return false;

	// set site
	QDomElement siteElement = m_domDocument.createElement( TAG_SITE );
	siteElement.setAttribute( ATT_LABEL, Inf.label );
	m_domDocument.documentElement().appendChild( siteElement );
	// set host
	QString tmp = Inf.host;
	QDomElement tmpElement = m_domDocument.createElement( TAG_HOST );
	QDomText txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );
	// set port
	int p = Inf.port;
	tmpElement = m_domDocument.createElement( TAG_PORT );
	txtNode = m_domDocument.createTextNode( QString::number( p ) );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );
	// set protocol
	tmp = Inf.protocol;
	tmpElement = m_domDocument.createElement( TAG_PROTOCOL );
	txtNode = m_domDocument.createTextNode( tmp );
	tmpElement.appendChild( txtNode );
	siteElement.appendChild( tmpElement );
	// set remote directory
	if( !Inf.remotePath.isEmpty() ) {
		tmp = Inf.remotePath;
		tmpElement = m_domDocument.createElement( TAG_REMOTE_PATH );
		txtNode = m_domDocument.createTextNode( tmp );
		tmpElement.appendChild( txtNode );
		siteElement.appendChild( tmpElement );
	}
	// set username
	if( !Inf.user.isEmpty() ) {
		tmp = Inf.user;
		tmpElement = m_domDocument.createElement( TAG_USER );
		txtNode = m_domDocument.createTextNode( tmp );
		tmpElement.appendChild( txtNode );
		siteElement.appendChild( tmpElement );
	}
	// set password
	if( !Inf.pass.isEmpty() ) {
		tmp = encodePassword( Inf.pass );
		tmpElement = m_domDocument.createElement( TAG_PASS );
		txtNode = m_domDocument.createTextNode( tmp );
		tmpElement.appendChild( txtNode );
		siteElement.appendChild( tmpElement );
	}
	// set anonym
	if( Inf.anonym ) {
		tmpElement = m_domDocument.createElement( TAG_ANONYMOUS );
		siteElement.appendChild( tmpElement );
	}
	return true;
}
//-----------------------------------------------
