/***************************************************************************
                          wincommanderimportfilterplugin.cpp  -  description
                             -------------------
    begin                : tis mar 19 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qdom.h>
#include <qdir.h>
#include <qstringlist.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <klocale.h>
#include <kconfig.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "wincommanderimportfilterplugin.h"
#include "kbeartags.h"
#include "misc.h"

#include "wincommanderimportfilterplugin.moc"

using namespace KBear;

typedef KGenericFactory<WinCommanderImportFilterPlugin> WinCommanderImportFilterPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearwincommanderimportfilter, WinCommanderImportFilterPluginFactory( "WinCommanderImportFilterPlugin" ) );
//-----------------------------------------------
WinCommanderImportFilterPlugin::WinCommanderImportFilterPlugin(QObject *parent, const char *name,const QStringList& )
	:	SiteImportFilterPluginIface(parent,name),
		m_hasError( false )
{
//	setXMLFile("wincommanderimportfilterui.rc");
	(void) KGlobal::locale()->insertCatalogue( QString::fromLatin1("kbear" ));
	m_domDocument.setContent( QString("<%1 %2=\"%3\"/>").arg(TAG_GROUP).arg(ATT_LABEL).arg(i18n("Windows Commander import")) );
}
//-----------------------------------------------
WinCommanderImportFilterPlugin::~WinCommanderImportFilterPlugin(){
}
//-----------------------------------------------
QString WinCommanderImportFilterPlugin::getDomDocument() {
	return m_domDocument.toString();
}
//-----------------------------------------------
void WinCommanderImportFilterPlugin::import( const QString& fileName ) {
	if( fileName.isEmpty() || fileName.isNull() ) {
		KMessageBox::sorry( 0, i18n("You have to select a file to import."), i18n("No file") );
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	int answer = KMessageBox::warningContinueCancel( 0,
					i18n("Currently this import filter can't import the passwords in this file.\n"
							"Because of this you have retype the passwords before using the bookmark."), i18n("Password") );
	if( answer == KMessageBox::Cancel ) {
		m_hasError = true;
		emit progress( 100 );
		return;
	}
	KConfig config( fileName, true, false, "HOME");
	// First we fetch some global settings
	config.setGroup( QString::fromLatin1("General") );
	QString email = config.readEntry( QString::fromLatin1("e-mail"), QString::fromLatin1("anonymous@") );	

	QStringList siteList = config.groupList();
	float size = (float)siteList.count();
	if( size == 0 ) {
		invalidFileError( fileName );
		m_hasError = true;
		emit progress( 100 );
		return;
	}	
	int counter = 0;
	const QString anonymStr = QString::fromLatin1( "anonymous" );
	for( QStringList::Iterator it = siteList.begin(); it != siteList.end(); ++it ) {
		QString siteName = *it;
		QDomNode siteNode;
		QDomElement parentElement = m_domDocument.documentElement();
		config.setGroup( siteName );
		QString tmp = config.readEntry(TAG_HOST, QString::null );  // we ignore the site if it hasn't any host
		// first  check so the site has a host, if not ignore it
		if( ! tmp.isNull() || ! tmp.isEmpty() ) {  // had host
			// set label
			QDomElement siteElement = m_domDocument.createElement( TAG_SITE );
			siteElement.setAttribute( ATT_LABEL, siteName );			
			parentElement.appendChild( siteElement );	
			// set host
			QDomElement tmpElement = m_domDocument.createElement( TAG_HOST );
			QDomText txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set port
			tmpElement = m_domDocument.createElement( TAG_PORT );
			txtNode = m_domDocument.createTextNode( QString::number( 21 ) );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set protocol
			tmpElement = m_domDocument.createElement( TAG_PROTOCOL );
			txtNode = m_domDocument.createTextNode( QString::fromLatin1("ftp") );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set remote directory
			tmp = config.readEntry( QString::fromLatin1("directory"), QString::fromLatin1("/") );
			tmpElement = m_domDocument.createElement( TAG_REMOTE_PATH );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set local directory
			tmp = config.readEntry( QString::fromLatin1("localdir"), QString::fromLatin1("/") );
			tmpElement = m_domDocument.createElement( TAG_LOCAL_PATH );
			txtNode = m_domDocument.createTextNode( QDir::homeDirPath() );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set username
			tmp = config.readEntry( QString::fromLatin1("username"), anonymStr );
			tmpElement = m_domDocument.createElement( TAG_USER );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set password
			if( tmp == anonymStr ) {
				tmp = encodePassword( email );
			}
			else {
				tmp = QString::null;  // we ignore the site if it hasn't any host
			}
			tmpElement = m_domDocument.createElement( TAG_PASS );
			txtNode = m_domDocument.createTextNode( tmp );
			tmpElement.appendChild( txtNode );
			siteElement.appendChild( tmpElement );	
			// set PASV
			int p = config.readNumEntry( QString::fromLatin1("pasvmode"), 1 );
			if( p != 1 ) {
				tmpElement = m_domDocument.createElement( TAG_DISABLE_PASV );
				siteElement.appendChild( tmpElement );	
			}
		}
		emit progress( int(float(counter) / size * 100) );	
		counter++;	
	}	
	emit progress( 100 );
}
//-----------------------------------------------
void WinCommanderImportFilterPlugin::invalidFileError(const QString& fileName){
	KMessageBox::sorry( 0, i18n("The file: %1\nis either empty or it's not a valid Windows Commander bookmarks file.").arg(fileName), i18n("Invalid import file") );
}
//-----------------------------------------------
