/***************************************************************************
                          kbearlogview.h  -  description
                             -------------------
    begin                : sn feb 10 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARLOGVIEW_H
#define KBEARLOGVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
#include <qcolor.h>
#include <qfont.h>
#include <qintdict.h>
#include <qfile.h>
//////////////////////////////////////////////////////
// KDE specific includes
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartabview.h"
#include "kbeartextedit.h"
#include "siteinfo.h"

using namespace KBear;

namespace KBear {
	class KBearChildViewIface;
};
class KMdiChildView;
class QTextCodec;
class KConfig;
/**
  *@author Bjrn Sahlstrm
  */

class KBearLogView : public QTabWidget /*KBear::KBearTabView*/  {
   Q_OBJECT
public: 
	/** No descriptions */
	KBearLogView( KConfig* config, QWidget *parent=0, const QString& name=0);
	/** No descriptions */
	~KBearLogView();
	void initValues();
public slots: // Public slots
	/** No descriptions */
	void slotAddPage( const SiteInfo& info );
	/** No descriptions */
	void slotRemovePage( int );
	/** No descriptions */
	void slotLogMessage( int, const QString& mess );
	/** No descriptions */
	void slotSetActiveLogTab( KBearChildViewIface* );
private:
	void maybeDeleteLogFile( const QFile& file, unsigned int intervall );
private:
	QColor m_commandColor;
	QColor m_responseColor;
	QColor m_multiLineColor;
	bool m_enableFileLog;
	unsigned int m_overWriteFileLog;
	bool m_showClientCommand;
	bool m_showServerCommand;
	QString m_logFilePath;
	KConfig* m_config;
	QFont m_font;
	QIntDict<QFile> m_logFiles;
	QIntDict<QTextStream> m_logStreams;
	QIntDict<SiteInfo> m_sites;
	QIntDict<QWidget> m_tabs;
};

#endif
