/*********************************************************************************
* C++ Interface: kbearrecentconnectionsitem.h
* Description:
*
* Begin : lr jun 28 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef KBEARKBEARRECENTCONNECTIONSITEM_H
#define KBEARKBEARRECENTCONNECTIONSITEM_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qtimer.h>
#include <qvaluelist.h>
#include <qpixmap.h>
#include <qdatetime.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files

class KConfig;

namespace KBear {

	/**
	@author Bjrn Sahlstrm
	*/
	class KBearRecentConnectionsItem : public QObject, public QListViewItem {
		Q_OBJECT
	public:
		/** */
		KBearRecentConnectionsItem( KConfig* config, KListView* view, const QString&  text );
		/** */
		virtual ~KBearRecentConnectionsItem();
		/** */
		void addReference( int ID );
		/** */
		void removeReference( int ID );
	private slots:
		void slotUpdateTime();
		void slotConnected( int ID );
		void slotConnectionClosed( int ID );
	private:
		QTimer m_connectedTimer;
		QDateTime m_myTime;
		KConfig* m_config;
		QValueList<int> m_references;
		static const QPixmap s_connectedPix;
		static const QPixmap s_disconnectedPix;
	};

};

#endif
