/*********************************************************************************
* C++ Interface: kbearrecentconnectionsplugin..h
* Description:
*
* Begin : fre jun 27 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


#ifndef __KBEARPLUGIN_RECENTCONNECTIONS_H__
#define __KBEARPLUGIN_RECENTCONNECTIONS_H__

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpoint.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearplugin.h"
#include "kbearrecentconnectionsoutputwidget.h"
#include "siteinfo.h"


class KAction;
class KSelectAction;
class KConfig;

namespace KBear {
	class KBearRecentConnectionsOutputWidget;

	/**
	@author Bjrn Sahlstrm
	*/
	class KBearRecentConnectionsPlugin : public KBear::KBearPlugin {
		Q_OBJECT
	public:
		/** */
		KBearRecentConnectionsPlugin(QObject* parent, const char* name, const QStringList& args = QStringList());
		/** */
		virtual ~KBearRecentConnectionsPlugin();
	public slots:
		/** */
		virtual void slotInit();
		void slotOpenRecent( const QString& );
		void slotClearRecent();
		void slotAddToRecent( const SiteInfo&, const SiteInfo& );
	private slots:
		void slotContextMenu( KListView*, QListViewItem*, const QPoint& );
		void slotOpenSelected();
	private:
		void loadRecent();
	private:
		KAction* m_clearRecentAction;
		KAction* m_openRecentAction;
		KSelectAction* m_recentAction;
		KBearRecentConnectionsOutputWidget* m_outputWidget;
		KConfig* m_config;
	};
};

#endif
