/***************************************************************************
                          kbearsitemanager.h  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGER_H
#define KBEARSITEMANAGER_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qvaluelist.h>
#include <qwidget.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kcombobox.h>
#include <kdialogbase.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanageriface.h"

class QWidget;
class QCheckBox;
class QGroupBox;
class QRadioButton;
class QHButtonGroup;
class KListView;
class KPushButton;
class KComboBox;
class KTextEdit;
class KLineEdit;
class KIntSpinBox;
class KTabCtl;
class KProgress;
class KBearSiteManagerTreeView;
class KBearSiteImportWidget;
/**
  *@author Bjrn Sahlstrm
  */

class KBearSiteManager : public KDialogBase {
   Q_OBJECT
   friend class KBearSiteManagerPlugin;
public: 
	/** */
	KBearSiteManager(QWidget *parent, const char *name );
	/** */
	~KBearSiteManager();
	/** */
	void setSite( const SiteInfo& );
	/** */
	bool hasKBearFTP() const { return m_hasKBearFTP; }
	/** */
	void setPlugIntoKonq( bool );
	/** */
	QString promptForGroupName();
	/** */
	SiteInfo getCurrentSite();
	/** */
	void clear();
	/** */
	bool checkModified();
public slots:
	/** */
	virtual void slotSelectedSite(QListViewItem* item = 0L);

signals:
	/** */
	void update();
	/** */
//	void showSystemTray(bool);
	/** */
	void plugInKonq( bool );
	/** */
	void importSites( const QString& );
	/** */
	void siteSelected( const SiteInfo& );
	/** */
	void selectionCleared();
	/** */
	void openConnection( const SiteInfo& );
	/** */
	void saveSite( const SiteInfo& );
	/** */
	void changeSite( const SiteInfo&, const QString& oldName );
	/** */
	void changeGroup( const Group&, const QString& oldName );
	/** */
	void newGroup( const Group& name );
	/** */
	void moveSite( const SiteInfo& site, const QString& newParent );
	/** */
	void moveGroup( const Group& group, const QString& newParent );
	/** */
	void newEncoding( const QString& encoding );
	/** */
	void removeSite( const SiteInfo& );
	/** */
	void removeGroup( const Group& );
protected slots:
	/** */
	virtual void slotClose();
	/** */
	virtual void slotItemRenamed(QListViewItem*, const QString&, int);
	/** */
    virtual void slotSetEdited();
	/** */
    virtual void slotSetHostEdited();
	/** */
	virtual void slotConnect();
	/** */
	virtual void slotAboutToShowPage( QWidget* );
	/** */
	virtual void slotDoubleClicked(QListViewItem *);
	/** */
	virtual void slotMoved(const QString& parentPath, const QString& name, QListViewItem* newParent,bool isGroup);
	/** */
	virtual void slotNewGroup();
	/** */
	virtual void slotRemove();
	/** */
	virtual void slotSave();
	/** */
	virtual void slotSetEncoding(const QString&);
	/** */
	virtual void slotSelectedProtocol( const QString& );
	/** */
	virtual void slotPressed(QListViewItem*);
	/** */
	virtual void slotContextMenu( KListView*, QListViewItem* item, const QPoint& );
	/** */
	virtual void slotUpdateAdv();
	/** */
	virtual void slotSiteLabelChanged();
	/** */
	virtual void slotListCmdEditChanged( const QString& );
private: //Private methods
	void setupProtocolCombo();
	void setupGUI();
	void setupConnections();
public:
	KBearSiteManagerTreeView *siteTreeView;	
protected:
	/** This must be protected so SiteManagerPlaugin can reach it	 */
	KBearSiteImportWidget *m_importWidget;
private: //Private attributes
	bool m_hasKBearFTP;
	bool m_pendingConnect;
	bool m_isModified;
	bool m_groupSelected;
	SiteInfo m_selectedItem;
	Group m_movedItem;
	QWidget *m_advancedWidget;
//	QCheckBox *m_systemtrayCheckBox;
	QCheckBox *m_plugkonqCheckBox;
	QCheckBox *m_anonymousCheckBox;
	QCheckBox *m_advPasvCheckBox;
	QCheckBox *m_advEpsvCheckBox;
	QCheckBox *m_advListCmdCheckBox;
	QCheckBox *m_advPartCheckBox;
	QCheckBox *m_advLogCheckBox;
//	QCheckBox *m_advQueueCheckBox;
	QCheckBox *m_advSingleCheckBox;
	QCheckBox *m_advReconnectCheckBox;
/* Removed since this is now a globally option
	QRadioButton *m_advBinaryRadio;
	QRadioButton *m_advAsciiRadio;
	QHButtonGroup *m_advTransferGroup;
*/
	QGroupBox *m_groupBox;
	KLineEdit *m_advListCmdEdit;
	KLineEdit *m_siteEdit;
	KLineEdit *m_hostnameEdit;
	KLineEdit *m_passwordEdit;
	KLineEdit *m_localdirEdit;
	KLineEdit *m_remotedirEdit;
	KTextEdit *m_descriptionEdit;
	KPushButton *m_reloadButton;
	KPushButton *m_importButton;
	KPushButton *m_newgroupButton;
	KPushButton *m_removeButton;
	KPushButton *m_connectButton;
	KIntSpinBox *m_portSpinBox;
	KIntSpinBox *m_advWaitSpinBox;
	KIntSpinBox *m_advRetriesSpinBox;
	KComboBox *m_encodingComboBox;
	KComboBox *m_protocolComboBox;
	KComboBox *m_usernameComboBox;
	KComboBox *m_advEncodingComboBox;
};

#endif
