/***************************************************************************
                          kbearsitemanagerplugin.h  -  description
                             -------------------
    begin                : sn mar 17 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERPLUGIN_H
#define KBEARSITEMANAGERPLUGIN_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdom.h>
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kparts/plugin.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsitemanageriface.h"
#include "kbearplugin.h"

class KBearSiteManager;
class KActionMenu;
class KAction;
class KSelectAction;
class KActionCollection;
class KActionSeparator;
class QListViewItem;
class KConfig;
/**
  *@author Bjrn Sahlstrm
  */
 
class KBearSiteManagerPlugin : public KBear::KBearPlugin, virtual public KBearSiteManagerDCOPIface  {
   Q_OBJECT
public: 
	/** */
	KBearSiteManagerPlugin(QObject* parent=0, const char* name=0, const QStringList& args = QStringList());
	/** */
	~KBearSiteManagerPlugin();
	/** */
	virtual QString unloadWarning() const;
public slots:
	/** */
	virtual void slotNewSite( SiteInfo site );
	/**	*/
	virtual void slotSiteChanged( SiteInfo site, QString oldName );
	/** */
	virtual void slotSiteRemoved( SiteInfo site );
	/**	*/
	virtual void slotSiteMoved( SiteInfo site, QString oldParent, QString oldName );
	/**	*/
	virtual void slotNewGroup( Group group );
	/**	*/
	virtual void slotGroupChanged( Group group, QString oldName );
	/**	*/
	virtual void slotGroupRemoved( Group group );
	/**	*/
	virtual void slotGroupMoved( Group site, QString oldParent );
	/**	*/
	virtual void slotEncodingChanged( QString encoding );
	/**	*/
	virtual void slotUpdateDatabase( QString domTree );
	/** */
	virtual void slotImportOldSitemanager( QString );
	/** */
//	virtual void setShowSystemTray( bool );
	/** */
	virtual void setPlugInKonq( bool );
	/** */
	virtual void slotInitialize();
	/** */
	virtual void slotInit();
private slots:
	void slotUpdate();
	void slotSiteSelected( const SiteInfo& );
	void slotSelectionCleared();
	void slotImportSites( const QString&);
	void slotOpenSiteManager();
	void slotOpenConnection( const SiteInfo& );
	void slotBookmarkActivated();
	void slotAddGroup();
	void slotAddGroup( const Group& name );
	void slotMoveSite( const SiteInfo& site, const QString& oldName );
	void slotMoveGroup( const Group& group, const QString& oldName );
	void slotChangeGroup( const Group&, const QString& );
	void slotChangeSite( const SiteInfo&, const QString& );
	void slotAddBookmark();
	void slotSaveSite( const SiteInfo& site );
	void slotRemoveSite( const SiteInfo& site );
	void slotRemoveGroup( const Group& group );
	void slotNewEncoding( const QString& encoding );
	void slotIdleTimeout();
//	void slotShowSystemTray(bool);
	void slotPlugInKonq( bool );
	void slotSystemTrayMenuNeeded( KPopupMenu* );
private:
	void setupActions();
	void setupConnections();
	void buildTree( QDomElement, QListViewItem*, KActionMenu* );
	void parseDatabase( const QString& );
private:
	QCString m_DB_DCOP_Name;
	QCString m_DB_DCOP_ID;
	KBearSiteManager* m_siteManager;
	KActionMenu* m_siteManagerMenu;
	KAction* m_siteManagerAction;
	KAction* m_clearRecentAction;
	KSelectAction* m_recentAction;
	KActionSeparator* m_actionSeparator;
	KActionCollection* m_privateActionCollection;
	QTimer m_idleTimer;
	bool m_hasSelectedSite;
	SiteInfo* m_pendingSelectedSite;
	bool m_kbearMode;
};

#endif
