/***************************************************************************
                          kbearsitemanagertreeview.h  -  description
                             -------------------
    begin                : fre mar 15 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARSITEMANAGERTREEVIEW_H
#define KBEARSITEMANAGERTREEVIEW_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtimer.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klistview.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
//#include "kbeartreeview.h"
//#include "KBearSiteManagerTreeViewItem.h"
#include "group.h"

/**
  *@author Bjrn Sahlstrm
  */
class KBearSiteManagerTreeViewItem : public QListViewItem  {
	friend class KBearSiteManagerTreeView;
public:
	~KBearSiteManagerTreeViewItem();
protected:
	/** */
	KBearSiteManagerTreeViewItem( QListView* parent, const QString& text );
	/** */
	KBearSiteManagerTreeViewItem( QListViewItem* parent, const QString& text );
	/** */
	virtual void setOpen( bool o );
	/** */
	virtual void setPixmap( const QPixmap& p );
	/** */
	const QPixmap* pixmap() const { return &m_pixmap; }
private: // Private attributes
	QPixmap m_pixmap;
	static QPixmap* m_folderOpen;
	static QPixmap* m_folderClosed;
};
  
class KBearSiteManagerTreeView : public KListView  {
   Q_OBJECT
public: 
	/** */
	KBearSiteManagerTreeView(QWidget *parent=0, const char *name=0);
	/** */
	~KBearSiteManagerTreeView();
	/** */
	QListViewItem* addSite( QListViewItem* parent, const QString& site );
	/** */
	QListViewItem* addGroup( QListViewItem* parent, const QString& group );
	/** */
	QString getParentString( QListViewItem* item ) const;
	/** */
	QString getFullPath( QListViewItem* item ) const;
	
	/** Searches the arents childs for specified name
	*@param parent is the parent item to search within
	*@param name is the name to search for
	*@return a pointer to the found item or NULL
	*/
	QListViewItem* findItemByName( const QListViewItem* parent, const QString& name );
	/** Searches the hole tree for specified group name
	*@param parent is the hole search path for the parent name to search for
	*@param name is the name to search for
	*@return a pointer to the found parent or NULL
	*/
	QListViewItem* findParentByFullName( const QString& name );
	/**
	* @param enable set this to false if you don't want DND.
	* By default DND is ON.
	*/
	void setDNDEnabled( bool enable = true );

signals:
	/** */
	void moved( const QString& parentPath, const QString& name, QListViewItem* newParent, bool );
	/** Emitted whenever a decodable item is dropped in the view */
	void dropped( QDropEvent* );
	/** Emitted whenever a decodable item is dropped in the view */
 	void dropped( KBearSiteManagerTreeView*, QDropEvent* );
protected:
	/**
	*Reimplemented from @ref KListView
	*/
	virtual bool acceptDrag(QDropEvent* e ) const;
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void startDrag();
	/**
	*Reimplemented from @ref KListView
	*/
	virtual void contentsDropEvent( QDropEvent* e );
	/**
	*Reimplemented from @ref KListView
	*/
 	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**
	*Reimplemented from @ref KListView
	*/
 	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**
	*Reimplemented from @ref KListView
	*/
 	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
private slots:
	virtual void slotExecuted( QListViewItem* );
	/** Called whenever the autoOpenTimer expires */
	void slotOpenFolder();
private: // methods
	void setupGUI();
private:
	QListViewItem* m_dropItem;
	QListViewItem* m_currentBeforeDropItem;
	QTimer m_autoOpenTimer;
	
};

#endif
