/*********************************************************************************
* C++ Implementation: kbeartransferoutputplugin.cpp
* Description:
*                              
* Begin : sn jan 26 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qtooltip.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kmainwindow.h>
#include <klocale.h>
#include <kglobal.h>
#include <kinstance.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kgenericfactory.h>
#include <kaboutapplication.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearsystemtraydockplugin.h"
#include "kbearsystemtraydock.h"
#include "kbearapi.h"
#include "kbearmainwiniface.h"
#include "kbearconfigwidgetiface.h"


#include "kbearsystemtraydockplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearSystemTrayDockPlugin> KBearSystemTrayDockPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbearsystemtraydock, KBearSystemTrayDockPluginFactory( "kbearsystemtraydock" ) );
//-----------------------------------------------
KBearSystemTrayDockPlugin::KBearSystemTrayDockPlugin( QObject* parent, const char* , const QStringList& )
	:	KBear::KBearPlugin( parent, "KBearSystemTrayDockPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance( KBearSystemTrayDockPluginFactory::instance() );

	setXMLFile( "kbearsystemtraydockplugin.rc" );

	m_dockWin = new KBearSystemTrayDock( m_api, m_api->mainWindow()->mainWindow(), "KBearSystemTrayDock" );
	KAction* action = new KToggleAction( i18n("Show SystemTray Icon" ), 0, this, SLOT( slotShowSystemTrayIcon() ), actionCollection(), "options_show_systray" );
	action->setToolTip( i18n("Toggle System Tray Icon" ) );
}
//-----------------------------------------------
KBearSystemTrayDockPlugin::~KBearSystemTrayDockPlugin() {
	delete m_dockWin;
}
//-----------------------------------------------
void KBearSystemTrayDockPlugin::slotInit()  {
	KConfig* config = KBearSystemTrayDockPluginFactory::instance()->config();
	KConfigGroupSaver( config, config->group() );
	config->setGroup( QString::fromLatin1("SystemTrayDock" ) );
	bool show = config->readBoolEntry( QString::fromLatin1("Show SystemTray Icon"), true );
	showSystemTrayIcon( show );
}
//-----------------------------------------------
void KBearSystemTrayDockPlugin::slotShowSystemTrayIcon() {
	QObject* obj = (QObject*)sender();
	if( obj == action( "options_show_systray" ) ) {
		showSystemTrayIcon( static_cast<KToggleAction*>( action( "options_show_systray" ) )->isChecked() );
	}
	else if( m_showSysTrayIconCheckBox ) { // if not the action it must be the settings dilaog / wizard
		showSystemTrayIcon( m_showSysTrayIconCheckBox->isChecked() );
	}
}
//-----------------------------------------------
void KBearSystemTrayDockPlugin::showSystemTrayIcon( bool show ) {
	action( "options_show_systray" )->blockSignals( true );
	static_cast<KToggleAction*>( action( "options_show_systray" ) )->setChecked( show );
	action( "options_show_systray" )->blockSignals( false );
	if( ! m_dockWin )
		return;
	if( show )
		m_dockWin->show();
	else
		m_dockWin->hide();
	KConfig* config = KBearSystemTrayDockPluginFactory::instance()->config();
	KConfigGroupSaver( config, config->group() );
	config->setGroup( QString::fromLatin1("SystemTrayDock" ) );
	config->writeEntry( QString::fromLatin1("Show SystemTray Icon"), show );
	config->sync();
}
//-----------------------------------------------
void KBearSystemTrayDockPlugin::slotConfigWidget( KDialogBase* dlg ) {
	KBearConfigWidgetIface* w = m_api->mainWindow()->miscSettingsWidget();
	if( ! w ) {
		return;
	}
	QGroupBox* groupBox = new QGroupBox( w, "groupBox" );
	groupBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed, 0, 0, groupBox->sizePolicy().hasHeightForWidth() ) );
	groupBox->setMinimumSize( QSize( 0, 45 ) );
	groupBox->setFrameShape( QFrame::Box );
	groupBox->setFrameShadow( QFrame::Raised );
	QHBoxLayout* groupBoxLayout = new QHBoxLayout( groupBox, 11, 6, "emailFrameLayout");

	m_showSysTrayIconCheckBox = new QCheckBox( groupBox, "KBearSystemTrayCheckBox" );
	m_showSysTrayIconCheckBox->setText( i18n( "Show SystemTray Icon" ) );
	m_showSysTrayIconCheckBox->setChecked( static_cast<KToggleAction*>( action( "options_show_systray" ) )->isChecked() );
	QString tmp = i18n("Uncheck this option if you don't want the system tray icon to be visible") ;
	QToolTip::add( m_showSysTrayIconCheckBox, tmp );
	QWhatsThis::add( m_showSysTrayIconCheckBox, tmp + QString::fromLatin1("\n")
					+ i18n("Note that this option only hides the icon, it wont unload the plugin. "
					"If you want to unload the plugin you can do so in the settings dialog.") );


	groupBoxLayout->addWidget( m_showSysTrayIconCheckBox, 0, 0 );
	w->swallow( groupBox );
	connect( dlg, SIGNAL( okClicked() ), this, SLOT( slotShowSystemTrayIcon() ) );
}
//-----------------------------------------------
void KBearSystemTrayDockPlugin::slotConfigWidget( KWizard* wiz ) {
	KBearConfigWidgetIface* w = m_api->mainWindow()->miscSettingsWidget();
	if( ! w ) {
		return;
	}
	QGroupBox* groupBox = new QGroupBox( w, "groupBox" );
	groupBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed, 0, 0, groupBox->sizePolicy().hasHeightForWidth() ) );
	groupBox->setMinimumSize( QSize( 0, 45 ) );
	groupBox->setFrameShape( QFrame::Box );
	groupBox->setFrameShadow( QFrame::Raised );
	QHBoxLayout* groupBoxLayout = new QHBoxLayout( groupBox, 11, 6, "emailFrameLayout");

	m_showSysTrayIconCheckBox = new QCheckBox( groupBox, "KBearSystemTrayCheckBox" );
	m_showSysTrayIconCheckBox->setText( i18n( "Show SystemTray Icon" ) );
	m_showSysTrayIconCheckBox->setChecked( static_cast<KToggleAction*>( action( "options_show_systray" ) )->isChecked() );
	QString tmp = i18n("Uncheck this option if you don't want the system tray icon to be visible") ;
	QToolTip::add( m_showSysTrayIconCheckBox, tmp );
	QWhatsThis::add( m_showSysTrayIconCheckBox, tmp + QString::fromLatin1("\n")
					+ i18n("Note that this option only hides the icon, it wont unload the plugin. "
					"If you want to unload the plugin you can do so in the settings dialog.") );


	groupBoxLayout->addWidget( m_showSysTrayIconCheckBox, 0, 0 );
	w->swallow( groupBox );
	connect( wiz->finishButton(), SIGNAL( clicked() ), this, SLOT( slotShowSystemTrayIcon() ) );
}
//-----------------------------------------------
