/*********************************************************************************
* C++ Implementation: kbeartipofdayplugin.cpp
* Description:
*                              
* Begin : tis jan 14 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <ktip.h>
#include <kaction.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartipofdayplugin.h"
#include "kbearmainwiniface.h"
#include "kbearcore.h"

#include "kbeartipofdayplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearTipOfDayPlugin> KBearTipOfDayPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbeartipofday, KBearTipOfDayPluginFactory( "kbeartipofday" ) );
//-----------------------------------------------
KBearTipOfDayPlugin::KBearTipOfDayPlugin( QObject* parent, const char* , const QStringList& )
  : KBearPlugin( parent, "KBearTipOfDayPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance ( KBearTipOfDayPluginFactory::instance() );
	setXMLFile("kbeartipofdayplugin.rc");
	KAction* action = new KAction( i18n("R&un Tip of Today"), "ktip", 0, this, SLOT( slotRunTipOfToday() ), actionCollection(), "help_show_tip" );
	action->setToolTip( i18n("Run the 'Tip of today' dialog.") );
	action->setWhatsThis( i18n("Push this button to run the 'Tip of today' dialog.\n"
													"You can also select the 'Run Tip of today' command from the 'Help' menu.") );
}
//-----------------------------------------------
KBearTipOfDayPlugin::~KBearTipOfDayPlugin() {
}
//-----------------------------------------------
void KBearTipOfDayPlugin::slotInit()  {
//	connect( actionCollection(), SIGNAL( actionStatusText(const QString &) ), mainWindow()->statusBar(), SLOT( message(const QString &) ) );
//	connect( actionCollection(), SIGNAL( clearStatusText() ), mainWindow()->statusBar(), SLOT( clear() ) );
	KTipDialog::showTip( mainWindow()->mainWindow(), "kbear/tips", false );
}
//-----------------------------------------------
void KBearTipOfDayPlugin::slotRunTipOfToday() {
	KTipDialog::showTip( mainWindow()->mainWindow(), "kbear/tips", true );
}
//-----------------------------------------------
