/***************************************************************************
                          kbeartoolswidget.cpp  -  description
                             -------------------
    begin                : sn mar 3 2002
    copyright            : (C) 2003 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpixmap.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kapplication.h>
#include <klistbox.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kconfig.h>
#include <kconfigbase.h>
#include <kiconloader.h>
#include <kdesktopfile.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartoolswidget.h"
#include "treeview.h"
#include "entry.h"

//-----------------------------------------------
KBearToolsWidget::KBearToolsWidget(QWidget *parent, const char *name )
	:	KBearConfigWidgetIface( parent, name )
{
	setupGUI();
	m_applications.setAutoDelete(true);
	loadToolsList();
	slotEnableButtons();
}
//-----------------------------------------------
KBearToolsWidget::~KBearToolsWidget(){
}
//-----------------------------------------------
void KBearToolsWidget::slotToList() {
	TreeItem *item = (TreeItem*) m_applicationsTreeView->selectedItem();
	if(item && ! item->desktopEntryPath().isEmpty() ) {
		addToList( item->desktopEntryPath() );
	}
	slotEnableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotToTree() {
	if( ! m_toolsMenuList->currentItem() )
		return;
	m_applications.remove( m_toolsMenuList->currentItem() );
	updateList();
	slotEnableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotUp() {
	int current = m_toolsMenuList->currentItem();
	Entry* entry = m_applications.take( current );
	m_applications.insert( current - 1, entry );
	updateList();
	m_toolsMenuList->setCurrentItem( current - 1 );
	slotEnableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::slotDown() {
	int current = m_toolsMenuList->currentItem();
	Entry* entry = m_applications.take( current );
	m_applications.insert( current + 1, entry );
	updateList();
	m_toolsMenuList->setCurrentItem( current + 1 );
	slotEnableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::loadToolsList() {
	m_applications.clear();
	KConfigGroupSaver cs( kapp->config(), kapp->config()->group() );
	kapp->config()->setGroup("Tools");
	QStringList list = kapp->config()->readListEntry("Tools");

	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it)
		addToList(*it);
}
//-----------------------------------------------
void KBearToolsWidget::slotSaveToolsList() {
	KConfigGroupSaver cs( kapp->config(), kapp->config()->group() );
	kapp->config()->setGroup("Tools");

	QStringList list;
	QPtrListIterator<Entry> it( m_applications );
	for( ; it.current(); ++it)
		list.append(it.current()->desktopFile);

	kapp->config()->writeEntry("Tools", list);
	kapp->config()->sync();
	emit update();
}
//-----------------------------------------------
void KBearToolsWidget::addToList(const QString &desktopFile) {
	KDesktopFile df(desktopFile, true);

	if(df.readName().isEmpty())
		return;

	Entry *entry = new Entry;

	if(!df.readIcon().isEmpty())
		entry->icon = BarIcon(df.readIcon());
	entry->name = df.readName();
	entry->desktopFile = desktopFile;

	m_applications.append(entry);

	updateList();
	slotEnableButtons();
}
//-----------------------------------------------
void KBearToolsWidget::updateList() {
	m_toolsMenuList->setUpdatesEnabled(false);
	m_toolsMenuList->clear();

	QPtrListIterator<Entry> it( m_applications );
	for( ; it.current(); ++it)
		m_toolsMenuList->insertItem(it.current()->icon, it.current()->name);

	m_toolsMenuList->setUpdatesEnabled(true);
	m_toolsMenuList->repaint();
}
//-----------------------------------------------
void KBearToolsWidget::slotEnableButtons() {
	m_toListButton->setEnabled( m_applicationsTreeView->selectedItem() && ! m_applicationsTreeView->selectedItem()->firstChild());
	m_toTreeButton->setEnabled( m_toolsMenuList->currentItem() >= 0 || (unsigned int)m_toolsMenuList->currentItem() < m_toolsMenuList->count());
	m_upButton->setEnabled( m_toolsMenuList->currentItem() > 0 
							&& (unsigned int)m_toolsMenuList->currentItem() < m_toolsMenuList->count() 
							&& m_toolsMenuList->count() > (unsigned int)1);
	m_downButton->setEnabled( m_toolsMenuList->currentItem() >= 0 
	 						&& (unsigned int)m_toolsMenuList->currentItem() < m_toolsMenuList->count()-1 
							&& m_toolsMenuList->count() > (unsigned int)1 );

}
//-----------------------------------------------
void KBearToolsWidget::setupGUI() {
//	resize( 560, 480 );
	QGridLayout* widgetLayout = new QGridLayout( this, 1, 1, 11, 6, "widgetLayout");

	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>The tools menu is a plugin that let you configure launch buttons for various applications."
															"The choosen buttons will be placed in the <b>Tools menu</b> as well as in a Toolbar. "
															"The applications shown in the right sections are the ones that will be displayed.</p>" ) );
	infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	widgetLayout->addMultiCellWidget( infoLabel, 0, 0, 0, 2 );


	QVBoxLayout* appLayOut = new QVBoxLayout( 0, 0, 6, "appLayOut");

	QLabel* appLabel = new QLabel( this, "appLabel" );
	appLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, appLabel->sizePolicy().hasHeightForWidth() ) );
	appLabel->setFrameShape( QLabel::MShape );
	appLabel->setFrameShadow( QLabel::Plain );
	appLabel->setText( i18n( "Applications" ) );
	appLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
	appLayOut->addWidget( appLabel );

	m_applicationsTreeView = new TreeView( this, "m_applicationsTreeView" );
	appLayOut->addWidget( m_applicationsTreeView );

	widgetLayout->addMultiCellLayout( appLayOut, 1, 3, 0, 0 );

	QVBoxLayout* toolsLayOut = new QVBoxLayout( 0, 0, 6, "toolsLayOut"); 

	QLabel* toolsMenuLabel = new QLabel( this, "toolsMenuLabel" );
	toolsMenuLabel->setText( i18n( "Tools menu" ) );
	toolsLayOut->addWidget( toolsMenuLabel );

	m_toolsMenuList = new KListBox( this, "m_toolsMenuList" );
	m_toolsMenuList->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)7, 0, 0, m_toolsMenuList->sizePolicy().hasHeightForWidth() ) );
	toolsLayOut->addWidget( m_toolsMenuList );

	widgetLayout->addMultiCellLayout( toolsLayOut, 1, 3, 2, 2 );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	widgetLayout->addItem( spacer, 2, 2 );

	QVBoxLayout* upperButtonLayOut = new QVBoxLayout( 0, 0, 6, "upperButtonLayOut"); 
	QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	upperButtonLayOut->addItem( spacer_2 );

	m_toListButton = new KPushButton( this, "m_toListButton" );
	m_toListButton->setEnabled( FALSE );
	m_toListButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)1, 0, 0, m_toListButton->sizePolicy().hasHeightForWidth() ) );
	m_toListButton->setMinimumSize( QSize( 90, 30 ) );
	m_toListButton->setText( QString::null );
	m_toListButton->setPixmap( BarIcon("2rightarrow") );
	upperButtonLayOut->addWidget( m_toListButton );
	QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	upperButtonLayOut->addItem( spacer_3 );

	m_toTreeButton = new KPushButton( this, "m_toTreeButton" );
	m_toTreeButton->setEnabled( FALSE );
	m_toTreeButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)1, 0, 0, m_toTreeButton->sizePolicy().hasHeightForWidth() ) );
	m_toTreeButton->setMinimumSize( QSize( 90, 30 ) );
	m_toTreeButton->setText( QString::null );
	m_toTreeButton->setPixmap( BarIcon("2leftarrow") );
	upperButtonLayOut->addWidget( m_toTreeButton );

	widgetLayout->addLayout( upperButtonLayOut, 1, 1 );

	QVBoxLayout* lowerButtonLayOut = new QVBoxLayout( 0, 0, 6, "lowerButtonLayOut"); 

	m_upButton = new KPushButton( this, "m_upButton" );
	m_upButton->setText( QString::null );
	m_upButton->setPixmap( BarIcon("2uparrow") );
	lowerButtonLayOut->addWidget( m_upButton );
	QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	lowerButtonLayOut->addItem( spacer_4 );

	m_downButton = new KPushButton( this, "m_downButton" );
	m_downButton->setText( QString::null );
	m_downButton->setPixmap( BarIcon("2downarrow") );
	lowerButtonLayOut->addWidget( m_downButton );
	QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
	lowerButtonLayOut->addItem( spacer_5 );

	widgetLayout->addLayout( lowerButtonLayOut, 3, 1 );

	// signals and slots connections
	connect( m_toolsMenuList, SIGNAL( currentChanged(QListBoxItem*) ), this, SLOT( slotEnableButtons() ) );
	connect( m_applicationsTreeView, SIGNAL( currentChanged(QListViewItem*) ), this, SLOT( slotEnableButtons() ) );
	connect( m_toListButton, SIGNAL( clicked() ), this, SLOT( slotToList() ) );
	connect( m_toTreeButton, SIGNAL( clicked() ), this, SLOT( slotToTree() ) );
	connect( m_upButton, SIGNAL( clicked() ), this, SLOT( slotUp() ) );
	connect( m_downButton, SIGNAL( clicked() ), this, SLOT( slotDown() ) );
	connect( m_toolsMenuList, SIGNAL( doubleClicked( QListBoxItem* ) ), this, SLOT( slotToTree() ) );
	connect( m_applicationsTreeView, SIGNAL( doubleClicked( QListViewItem* ) ), this, SLOT( slotToList() ) );

	widgetLayout->activate();
}
//-----------------------------------------------
#ifndef NO_INCLUDE_MOCFILES
#include "kbeartoolswidget.moc"
#endif

