/*********************************************************************************
* C++ Implementation: kbeartransferoutputplugin.cpp
* Description:
*                              
* Begin : lr jan 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpopupmenu.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kglobal.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbeartransferoutputplugin.h"
#include "kbeartransferview.h"
#include "transferviewpage.h"
#include "kbearmainwiniface.h"
#include "transfermanager.h"
#include "transferitem.h"
#include "connectionmanager.h"
#include "kbearcore.h"


#include "kbeartransferoutputplugin.moc"

using namespace KBear;
//-----------------------------------------------
typedef KGenericFactory<KBearTransferOutputPlugin> KBearTransferOutputPluginFactory;
K_EXPORT_COMPONENT_FACTORY( kbeartransferoutput, KBearTransferOutputPluginFactory( "kbeartransferoutput" ) );
//-----------------------------------------------
KBearTransferOutputPlugin::KBearTransferOutputPlugin( QObject* parent, const char* , const QStringList& )
  : KBear::KBearPlugin( parent, "KBearTransferOutputPlugin" )
{
	KGlobal::locale()->insertCatalogue("kbear");
	setInstance( KBearTransferOutputPluginFactory::instance() );
	setXMLFile( "kbeartransferoutputplugin.rc" );
	m_transferView = new KBearTransferView( instance()->config() );
	
	m_startAction = new KAction( i18n("&Start transfer"),"launch", 0, m_transferView, SLOT( slotStart() ), actionCollection(), "transfer_start" );
	m_startAction->setToolTip( i18n("Start selected transfer.") );
	m_startAction->setEnabled( false );

	m_stopAction = new KAction( i18n("S&top transfer"),"stop", 0, m_transferView, SLOT( slotStop() ), actionCollection(), "transfer_stop" );
	m_stopAction->setToolTip( i18n("Stop selected transfer.") );
	m_stopAction->setEnabled( false );

	m_pauseAction = new KAction( i18n("&Pause transfer"),"player_pause", 0, m_transferView, SLOT( slotPause() ), actionCollection(), "transfer_pause" );
	m_pauseAction->setToolTip( i18n("Pause selected transfer.") );
	m_pauseAction->setEnabled( false );

	m_continueAction = new KAction( i18n("&Continue transfer"),"finish", 0, m_transferView, SLOT( slotContinue() ), actionCollection(), "transfer_continue" );
	m_continueAction->setToolTip( i18n("Continue selected transfer.") );
	m_continueAction->setEnabled( false );

	m_expandAction = new KAction( i18n("&Expand progress tree"), 0, m_transferView, SLOT( slotExpand() ), actionCollection(), "transfer_expand" );
	m_expandAction->setToolTip( i18n("Expand the transfer progress tree.") );

	m_collapseAction = new KAction( i18n("C&ollapse progress tree"), 0, m_transferView, SLOT( slotCollapse() ), actionCollection(), "transfer_collapse" );
	m_collapseAction->setToolTip( i18n("Collapse the transfer progress tree.") );

	connect( m_api->core(), SIGNAL( newSite( const SiteInfo& ) ),
						m_transferView, SLOT( slotAddPage( const SiteInfo& ) ) );
	connect( m_transferView, SIGNAL( contextMenu( KListView*, QListViewItem*, const QPoint& ) ),
						this, SLOT( slotContextMenu( KListView*, QListViewItem*, const QPoint& ) ) );
}
//-----------------------------------------------
KBearTransferOutputPlugin::~KBearTransferOutputPlugin() {
	mainWindow()->removeOutputPluginView( m_transferView );
	delete m_transferView;

}
//-----------------------------------------------
void KBearTransferOutputPlugin::slotContextMenu( KListView*, QListViewItem* i , const QPoint& pos )  {
	TransferItem* item = dynamic_cast<TransferItem*>( i );

	m_startAction->setEnabled( false );
	m_stopAction->setEnabled( false );
	m_pauseAction->setEnabled( false );
	m_continueAction->setEnabled( false );

	Transfer* transfer = 0L;
	if( item )
		transfer = item->transfer();

	unsigned int status = Transfer::Uninitialized;
	if( transfer )
		status = transfer->status();

	m_startAction->setEnabled( status & (Transfer::Queued | Transfer::Canceled ) );
	m_stopAction->setEnabled( ( status == Transfer::Started ) );
	m_pauseAction->setEnabled( ( status == Transfer::Started ) );
	m_continueAction->setEnabled( ( status == Transfer::Paused ) );

	QPopupMenu* menu = ( factory() ? static_cast<QPopupMenu*>(factory()->container("transferoutput_popup", this)) : 0 );
	if( menu ) {
		menu->popup( pos );
	}
}
//-----------------------------------------------
void KBearTransferOutputPlugin::slotInit()  {
	mainWindow()->embedOutputPluginView( m_transferView, i18n( "Transfer Progress" ), i18n( "Display progress of all active transfers." ) );
}
//-----------------------------------------------
