/*********************************************************************************
* C++ Implementation: transferitem.cpp
* Description:
*
* Begin : tis jun 3 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qptrlist.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transfergroupitem.h"
#include "transfergroup.h"
#include "transfermanager.h"
#include "transfer.h"
#include "transferitem.h"
#include "siteinfo.h"
#include "transferviewpage.h"

using namespace KBear;

#include "transfergroupitem.moc"
//-----------------------------------------------
QPixmap* TransferGroupItem::s_folderClosed = 0L;
QPixmap* TransferGroupItem::s_folderOpen = 0L;
//-----------------------------------------------
TransferGroupItem::TransferGroupItem( TransferViewPage* page, TransferGroup* group )
	:	QListViewItem( page ),
		m_page( page ), m_transferGroup( group )
{
	setExpandable( true );
	if( ! s_folderClosed)
		s_folderClosed = new QPixmap( KGlobal::iconLoader()->loadIcon("folder",KIcon::Small, KIcon::SizeSmall ) );
	if( ! s_folderOpen)
		s_folderOpen = new QPixmap( KGlobal::iconLoader()->loadIcon("folder_open",KIcon::Small, KIcon::SizeSmall ) );

	QString host;
	QPtrList<Transfer>* transferList = group->transfers();
	SiteInfo sourceInfo = transferList->first()->sourceInfo();
	SiteInfo destInfo = transferList->first()->destInfo();
	if( sourceInfo.isLocal() || destInfo.isLocal() )  // transfer against local file sys
		host =i18n("Your Local File System" );
	else  // both source and dest are remote so we set dest here
		host = destInfo.label();

	int n = m_page->checkNameIntegrity( host );
	if( n ) {
		while( m_page->checkNameIntegrity( host+QString("( %1 )").arg( n+1 ) ) > 0 )
			++n;

		host += QString("( %1 )").arg( n+1 );
	}
	setText( 0, host );
	Transfer* transfer;
	TransferItem* item = 0L;
	for( transfer = transferList->first(); transfer; transfer = transferList->next() ) {
		if( item )
			item = new TransferItem( this, item, transfer );
		else
			item = new TransferItem( this, transfer );

		connect( item, SIGNAL( hidden() ), this, SLOT( slotTransferItemHidden() ) );
		connect( item, SIGNAL( shown() ), this, SLOT( slotTransferItemShown() ) );
		item->init();
		item->setOpen( false );
	}
	connect( TransferManager::getInstance(), SIGNAL( removingTransferGroup( int ) ),
					this, SLOT( slotRemovingTransferGroup( int ) ) );

	slotTransferItemHidden();

	if( transferList->isEmpty() ) // if no transfers, we delete ourself
		deleteLater();
}
//-----------------------------------------------
TransferGroupItem::~TransferGroupItem() {
}
//-----------------------------------------------
void TransferGroupItem::slotRemovingTransferGroup( int ID ) {
	if( m_transferGroup->ID() == ID ) {
		delete this;
	}
}
//-----------------------------------------------
void TransferGroupItem::slotTransferItemShown() {
	setVisible( true );
	QListViewItemIterator it( listView() );
	for( ; it.current(); ++it ) {
		TransferItem* item = dynamic_cast<TransferItem*>( it.current() ) ;
		if( item )
			item->setVisible( ! item->isHidden() );
	}
}
//-----------------------------------------------
void TransferGroupItem::slotTransferItemHidden() {
	QListViewItemIterator it( listView() );
	for( ; it.current(); ++it ) {
		TransferItem* item = dynamic_cast<TransferItem*>( it.current() ) ;
		if( item && ! item->isHidden() )
			return;
	}
	setVisible( false );
}
//-----------------------------------------------
void TransferGroupItem::setOpen( bool open ) {
	if( open )
		QListViewItem::setPixmap( 0, *s_folderOpen );
	else
		QListViewItem::setPixmap( 0, *s_folderClosed );

	QListViewItem::setOpen( open );
}
//-----------------------------------------------
