/*********************************************************************************
* C++ Implementation: transferviewpage.cpp
* Description:
*
* Begin : tis jun 3 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qwhatsthis.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transferviewpage.h"
#include "kbeartransferview.h"
#include "transfergroupitem.h"
#include "transfer.h"
#include "transfergroup.h"

using namespace KBear;

#include "transferviewpage.moc"
//-----------------------------------------------
TransferViewPage::TransferViewPage( KBearTransferView* parent, const char* name )
	:	KListView( parent, name ), m_transferView( parent )
{
	setRootIsDecorated ( true );
	setSorting( -1 ); // no sorting
	addColumn( i18n("Info type") );
	addColumn( i18n("Info") );
	setAllColumnsShowFocus( true );
	QWhatsThis::add( this, i18n("This window displays the progress and status of all current transfers for this site."));

}
//-----------------------------------------------
TransferViewPage::~TransferViewPage() {
}
//-----------------------------------------------
void TransferViewPage::addTransferGroup( TransferGroup* group ) {
	TransferGroupItem* item = new TransferGroupItem( this, group );
	item->setOpen( true );
}
//-----------------------------------------------
void TransferViewPage::setAllOpen( bool open ) {
	QListViewItemIterator it( this );
		for( ; it.current(); ++it ) {
			if( it.current()->isExpandable() )
				it.current()->setOpen( open );
		}

}
//-----------------------------------------------
int TransferViewPage::checkNameIntegrity( const QString& name ) const {
	int count = 0;
	QListViewItem* item = firstChild();
	while( item ) {
		if( dynamic_cast<TransferGroupItem*>( item ) ) {
			if( item->text( 0 ).left( name.length() ) == name )
				++count;
		}
		item = item->nextSibling();
	}
	return count;
}
//-----------------------------------------------
