/*********************************************************************************
* C++ Implementation: transferqueueconfigwidget.cpp
* Description:
*
* Begin : tor maj 08 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qsizepolicy.h>
#include <qwhatsthis.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klineedit.h>
#include <klocale.h>
#include <kconfig.h>
#include <kconfigbase.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transferqueueconfigwidget.h"


#include "transferqueueconfigwidget.moc"

using namespace KBear;
//-----------------------------------------------
// class TransferQueueConfigWidget
//-----------------------------------------------
TransferQueueConfigWidget::TransferQueueConfigWidget(KConfig* c, QWidget *parent, const char *name)
	:	KBearConfigWidgetIface( parent, name ),
		m_config( c )
{
	QGridLayout* myLayout = new QGridLayout( this, 1, 6 );

	m_queueCheckBox = new QCheckBox( this, "m_queueCheckBox" );
	m_queueCheckBox->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Preferred ) );
	m_queueCheckBox->setText( i18n( "Queue transfers when more than:." ) );
	QToolTip::add( m_queueCheckBox, i18n( "Check this option if you want all transfers over specified number to be queued." ) );
	QWhatsThis::add( m_queueCheckBox, i18n( "Check this option if you want all transfers over specified number to be queued.\n"
																			"If checked, this will override all other queue settings." ) );

	myLayout->addWidget( m_queueCheckBox, 0, 0 );

	m_countSpinBox = new QSpinBox( 1, 100, 1, this, "m_countSpinBox" );
	m_countSpinBox->setSizePolicy( QSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred ) );
	QToolTip::add( m_countSpinBox, i18n( "Set number of allowed transfers before they are queued." ) );
	QWhatsThis::add( m_countSpinBox, i18n( "Set number of allowed transfers before they are queued.\n"
																			"This means that there will never be more than this number of active transfers." ) );
	m_countSpinBox->setValue( 1 );

	myLayout->addWidget( m_countSpinBox, 0, 1 );

	QGroupBox* groupBox = new QGroupBox( this );
	groupBox->setColumnLayout(0, Qt::Vertical );
	groupBox->layout()->setSpacing( 6 );
	groupBox->layout()->setMargin( 11 );
	groupBox->setTitle( i18n( "Automation" ) );
	QGridLayout* groupBoxLayout = new QGridLayout( groupBox->layout() );
	groupBoxLayout->setAlignment( Qt::AlignTop );

	QLabel* disconnectCommandLabel = new QLabel( groupBox, "disconnectCommandLabel" );
	disconnectCommandLabel->setText( i18n( "Command to use for automatic disconnection:" ) );
	groupBoxLayout->addWidget( disconnectCommandLabel, 0, 0 );
	m_disconnectCommandLineEdit = new KLineEdit( groupBox, "m_disconnectCommandLineEdit" );
	groupBoxLayout->addWidget( m_disconnectCommandLineEdit, 0, 1 );
	m_sysShutdownCheckBox = new QCheckBox( groupBox, "m_sysShutdownCheckBox" );
	m_sysShutdownCheckBox->setText( i18n( "When auto shutdown is enabled also shutdown system" ) );
	groupBoxLayout->addMultiCellWidget( m_sysShutdownCheckBox, 1, 1, 0, 1 );
	QToolTip::add( m_disconnectCommandLineEdit, i18n( "Enter the command to use for disconnecting from network." ) );
	QWhatsThis::add( m_disconnectCommandLineEdit, i18n( "Enter the command to use for disconnecting from network." ) );
	QToolTip::add( m_sysShutdownCheckBox, i18n( "Check this if you want KBear to shutdown system when auto shutdown is enabled." ) );
	QWhatsThis::add( m_sysShutdownCheckBox, i18n( "Check this if you want KBear to shutdown the system when auto shutdown is enabled.\n"
			"This will cause your system to halt when the current download queue is empty. Note: this require that you are allowed to halt the system." ) );

	myLayout->addMultiCellWidget( groupBox,1, 1, 0, 1 );

	readSettings();

	myLayout->activate();

	connect( m_queueCheckBox, SIGNAL( toggled( bool ) ), this, SLOT( slotQueueToggled( bool ) ) );
}
//-----------------------------------------------
TransferQueueConfigWidget::~TransferQueueConfigWidget() {
	saveSettings();
}
//-----------------------------------------------
void TransferQueueConfigWidget::slotQueueToggled( bool enable ) {
	m_countSpinBox->setEnabled( enable );
}
//-----------------------------------------------
void TransferQueueConfigWidget::readSettings( bool defaultSettings ) {
	KConfigGroupSaver( m_config, m_config->group() );
	m_config->setGroup( QString::fromLatin1("TransferQueue" ) );
	if( defaultSettings ) {
		m_config->deleteEntry( QString::fromLatin1("SysShutdownWhenDone" ) );
		m_config->deleteEntry( QString::fromLatin1("DisconnectCommand" ) );
		m_config->deleteEntry( QString::fromLatin1("QueueTransfers" ) );
		m_config->deleteEntry( QString::fromLatin1("NumberOfTransfers" ) );
		m_config->sync();
	}
	m_sysShutdownCheckBox->setChecked( m_config->readBoolEntry( QString::fromLatin1("SysShutdownWhenDone"), false ) );
	m_queueCheckBox->setChecked( m_config->readBoolEntry( QString::fromLatin1("QueueTransfers"), false ) );
	m_countSpinBox->setValue( m_config->readUnsignedNumEntry( QString::fromLatin1("NumberOfTransfers"), 1 ) );
	m_disconnectCommandLineEdit->setText( m_config->readEntry( QString::fromLatin1("DisconnectCommand"), QString::fromLatin1("kppp -k") ) );

	slotQueueToggled( m_queueCheckBox->isChecked() );
}
//-----------------------------------------------
void TransferQueueConfigWidget::saveSettings() {
	KConfigGroupSaver( m_config, m_config->group() );
	m_config->setGroup( QString::fromLatin1("TransferQueue" ) );
	m_config->writeEntry( QString::fromLatin1("SysShutdownWhenDone"), m_sysShutdownCheckBox->isChecked() );
	m_config->writeEntry( QString::fromLatin1("DisconnectCommand"), m_disconnectCommandLineEdit->text() );
	m_config->writeEntry( QString::fromLatin1("QueueTransfers"), m_queueCheckBox->isChecked() );
	m_config->writeEntry( QString::fromLatin1("NumberOfTransfers"), m_countSpinBox->value() );
	m_config->sync();

	emit newSettings();
}
//-----------------------------------------------

