/*********************************************************************************
* C++ Interface: transferqueuesession.h
* Description:
*
* Begin : lr maj 31 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

#ifndef TRANSFERQUEUESESSION_H
#define TRANSFERQUEUESESSION_H

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qobject.h>
#include <qdom.h>
#include <qstring.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "siteinfo.h"

namespace KBear {
	class Transfer;
	class TransferQueueWidget;
	class KBearPlugin;
	class TransferQueueItem;

	/**
	@author Bjrn Sahlstrm
	*/
	class TransferQueueSession : public QDomDocument {
		public:
			/** */
			TransferQueueSession( KBearPlugin* plugin, TransferQueueWidget* );
			/** */
			virtual ~TransferQueueSession();
			/** */
			void clear();
			/** */
			void addTransfer( const KBear::Transfer* );
			/** */
			void removeTransfer( long ID );
			/** */
			void removeTransferGroup( int ID );
			/** */
			void updateTransfer( long ID, const QString& type, const QString& val );
			/** */
			void restoreSession();
			/** */
			static const QString& TAG_SESSION;
			/** */
			static const QString& TAG_TRANSFER_GROUP;
			/** */
			static const QString& TAG_TRANSFER;
			/** */
			static const QString& TAG_SOURCE_SITE;
			/** */
			static const QString& TAG_DEST_SITE;
			/** */
			static const QString& ATT_SOURCE_URL;
			/** */
			static const QString& ATT_DEST_URL;
			/** */
			static const QString& ATT_PROGRESS;
			/** */
			static const QString& ATT_STATUS;
			/** */
			static const QString& ATT_SIZE;
			/** */
			static const QString& ATT_TYPE;
			/** */
			static const QString& ATT_MIMETYPE;
			/** */
			static const QString& ATT_ID;
			/** */
			static const QString& ATT_VERSION;
		private:
			QDomElement findTransferGroup( int ID );
			QDomElement findTransfer( long ID );
			void parse( QDomElement parentElement );
		private:
			QString m_sessionFile;
			TransferQueueWidget* m_widget;
			KBearPlugin* m_plugin;
			const  unsigned int m_version;
	};
};

#endif
