/*********************************************************************************
* C++ Interface: transferqueuewidget.cpp
* Description:
*
* Begin : tor maj 08 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qpixmap.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kmimetype.h>
#include <kicontheme.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "transferqueuewidget.h"
#include "kbeartransferqueueplugin.h"
#include "transfer.h"
#include "misc.h"
#include "transfermanager.h"


#include "transferqueuewidget.moc"

using namespace KBear;


//-----------------------------------------------
const QPixmap TransferQueueItem::s_startedPix( started_xpm );
const QPixmap TransferQueueItem::s_stoppedPix( stopped_xpm );
const QPixmap TransferQueueItem::s_queuedPix( queued_xpm );
const QPixmap TransferQueueItem::s_pausedPix( paused_xpm );
const QPixmap TransferQueueItem::s_uninitializedPix( uninitialized_xpm );
//-----------------------------------------------
// class TransferQueueItem
//-----------------------------------------------
TransferQueueItem::TransferQueueItem( Transfer* transfer, QListView* p, const QString&t1,
											const QString& t2, const QString& t3, const QString& t4, const QString& t5, const QString& t6 )
	:	QListViewItem( p, t1, t2, t3, t4, t5, t6 ), m_transfer( transfer ), m_ID( (transfer?transfer->transferID():-1) )
{
	setTotalSize( 0 );
	setProgress( 0 );
	if( transfer )
		connectTransfer( transfer );
}
//-----------------------------------------------
TransferQueueItem::TransferQueueItem( Transfer* transfer, QListView* p, QListViewItem* after, const QString&t1,
											const QString& t2, const QString& t3, const QString& t4, const QString& t5, const QString& t6 )
	:	QListViewItem( p, after, t1, t2, t3, t4, t5, t6 ), m_transfer( transfer ), m_ID( (transfer?transfer->transferID():-1) )
{
	setTotalSize( 0 );
	setProgress( 0 );
	if( transfer )
		connectTransfer( transfer );
}
//-----------------------------------------------
void TransferQueueItem::connectTransfer( Transfer* transfer ) {
	connect( transfer, SIGNAL( statusChanged( long, unsigned int ) ),
						this, SLOT( slotTransferStatusChanged( long, unsigned int ) ) );
	connect( transfer, SIGNAL( percent( long, unsigned long ) ),
						this, SLOT( slotProgress( long, unsigned long ) ) );
	connect( transfer, SIGNAL( totalSize( long, KIO::filesize_t ) ),
						this, SLOT( slotTotalSize( long, KIO::filesize_t ) ) );
}
//-----------------------------------------------
void TransferQueueItem::paintCell(QPainter* p, const QColorGroup& cg, int column, int width, int align ) {
	if( column == 0 ) {
		QFont font = p->font();
		font.setBold( true );
		p->setFont( font );
	}
	QListViewItem::paintCell( p, cg, column, width, align );
}
//-----------------------------------------------
long TransferQueueItem::ID() const {
	return m_ID;
}
//-----------------------------------------------
void TransferQueueItem::slotProgress( long, unsigned long p ) {
	setProgress( p );
	emit progress( this, p );
}
//-----------------------------------------------
void TransferQueueItem::slotTotalSize( long, KIO::filesize_t size ) {
	setTotalSize( size );
	emit totalSize( this, size );
}
//-----------------------------------------------
void TransferQueueItem::slotTransferStatusChanged( long, unsigned int status ) {
	setStatus( status );
	emit statusChanged( this, status );
}
//-----------------------------------------------
void TransferQueueItem::setProgress( int progress ) {
	setPixmap( 3, KBear::createProgressPixmap( progress ) );
	QString p = i18n("%1 %").arg( progress );
	setText( 3 , p );
}
//-----------------------------------------------
void TransferQueueItem::setTotalSize( KIO::filesize_t totSize ) {
	if( totSize ==  0 )
		setText( 2 , i18n("Unknown") );
	else
		setText( 2 , i18n("%1").arg( KIO::convertSize( totSize ) ) );
}
//-----------------------------------------------
void TransferQueueItem::setStatus( unsigned int status ) {
	switch( status ) {
		case Transfer::Stopped:
			setPixmap( 0, s_stoppedPix );
			setText( 0, i18n("Stopped") );
			break;
		case Transfer::Canceled:
			setPixmap( 0, s_stoppedPix );
			setText( 0, i18n("Canceled") );
			break;
		case Transfer::Paused:
			setPixmap( 0, s_pausedPix );
			setText( 0, i18n("Paused") );
			break;
		case Transfer::Queued:
			setPixmap( 0, s_queuedPix );
			setText( 0, i18n("Queued") );
			break;
		case Transfer::Started:
			setPixmap( 0, s_startedPix );
			setText( 0, i18n("Started") );
			break;
		case Transfer::Finished:
			setPixmap( 0, s_stoppedPix );
			setText( 0, i18n("Finished") );
			slotProgress( 0, 100 );
			break;
		default:
			setPixmap( 0, s_uninitializedPix );
			setText( 0, i18n("Unknown") );
			break;
	};
}
//-----------------------------------------------
// class TransferQueueWidget
//-----------------------------------------------
TransferQueueWidget::TransferQueueWidget( KBearTransferQueuePlugin* plugin )
	:	KListView( 0L, "TransferQueueWidget" ),
		m_plugin( plugin )
{
	addColumn( i18n( "Status" ) );
	addColumn( i18n( "Source" ) );
	addColumn( i18n( "Size" ) );
	addColumn( i18n( "Progress" ) );
	addColumn( i18n( "Type" ) );
	addColumn( i18n( "Destination" ) );
	setSorting( -1 );
	setItemsMovable( false );
	setItemsRenameable( false );
	setDragEnabled( false );
	setAcceptDrops( false );
	setRootIsDecorated( true );
	setSelectionModeExt( KListView::Single );
	setAllColumnsShowFocus( true );
}
//-----------------------------------------------
void TransferQueueWidget::addTransfer( Transfer* transfer ) {
	QString ftpStr = QString::fromLatin1("kbearftp");
	KURL url = transfer->sourceURLs().first();
	if( url.protocol() == ftpStr )
		url.setProtocol( "ftp" );
	QString source =url.prettyURL();
	url = transfer->destURL();
	if( url.protocol() == ftpStr )
		url.setProtocol( "ftp" );
	QString dest = url.prettyURL();
	QString type = ( transfer->type() == Transfer::Move ) ? i18n("Move") : i18n("Copy");

	TransferQueueItem* item = 0L;
	if( childCount() == 0)
		item = new TransferQueueItem( transfer, this, i18n("Unknown") , source, i18n("Unknown") , "", type, dest );
	else
		item = new TransferQueueItem( transfer, this, lastItem(), i18n("Unknown"), source, i18n("Unknown"), "", type, dest );

	connect( item, SIGNAL( statusChanged( TransferQueueItem*, unsigned int ) ),
						m_plugin, SLOT( slotTransferStatusChanged( TransferQueueItem*, unsigned int ) ) );
	connect( item, SIGNAL( progress( TransferQueueItem*, unsigned long ) ),
						m_plugin, SLOT( slotProgress( TransferQueueItem*, unsigned long ) ) );
	connect( item, SIGNAL( totalSize( TransferQueueItem*, KIO::filesize_t ) ),
						m_plugin, SLOT( slotTotalSize( TransferQueueItem*, KIO::filesize_t ) ) );

	KMimeType::Ptr ptr = KMimeType::mimeType( transfer->mimetype() );
	item->setPixmap( 1, ptr->pixmap( KIcon::Small, 16 ) );

	item->setStatus( transfer->status() );
}
//-----------------------------------------------
void TransferQueueWidget::setColumnWidth( int column, int w ) {
	 w +=5; // add a little bit more space
	 KListView::setColumnWidth( column, w );
}
//-----------------------------------------------


