/*********************************************************************************
* C++ Implementation: kbearwizard.cpp
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
*********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qlabel.h>
#include <qpoint.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpixmap.h>
#include <qwmatrix.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kapplication.h>
#include <kstandarddirs.h>
#include <klocale.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "kbearwizard.h"
#include "kbearconfigwidgetiface.h"


#include "kbearwizard.moc"

using namespace KBear;
//-----------------------------------------------
QPixmap KBearWizard::KBearWizardPagePrivate::s_leftPic;
//-----------------------------------------------
KBearWizard::KBearWizardPagePrivate::KBearWizardPagePrivate( QWidget* parent, QWidget* child, const char* name  )
	:	QWidget( parent, name ), m_child( child )
{
	QGridLayout* layout = new QGridLayout( this, 1, 1, 11, 6, "KBearWizardPagePrivateLayout");
	QLabel* logo = new QLabel( this, "logo" );
	logo->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::MinimumExpanding, 0, 0, logo->sizePolicy().hasHeightForWidth() ) );
//	logo->setMinimumSize( QSize( 221, 0 ) );
//	logo->setMaximumSize( QSize( 221, 32767 ) );
	if( s_leftPic.isNull() ) {
//		s_leftPic = new QPixmap( locate("appdata","kbear-logo-rotated.jpg") );
//		s_leftPic = new QPixmap( locate("appdata","kbear-logo-top.jpg") );
		QPixmap tmp( locate("appdata","kbear-logo-top.jpg") );
		QWMatrix matrix;
		matrix.rotate( -90 );
		s_leftPic = tmp.xForm( matrix );
	}
	logo->setPixmap( s_leftPic );
	logo->setScaledContents( true );
	layout->addWidget( logo, 0, 0 );

	m_child->reparent( this, QPoint( 0, 0 ) );
	layout->addWidget( m_child, 0, 1 );
	layout->activate();
}
//-----------------------------------------------
KBearWizard::KBearWizard( QWidget* parent, const char* name )
  : KWizard( parent, name )
{
	setupGUI();
}
//-----------------------------------------------
KBearWizard::~KBearWizard() {
}
//-----------------------------------------------
void KBearWizard::addPage( QWidget* widget, const QString& title ) {
	KBearWizardPagePrivate* w = new KBearWizardPagePrivate( this, widget, title.latin1() );
	KWizard::addPage( w , title );
}
//-----------------------------------------------
void KBearWizard::removePage( QWidget* widget ) {
	for( int i = 0; i < pageCount(); i++ ) {
		if( KWizard::page( i ) == widget ) {
			KWizard::removePage( widget );
			return;
		}
	}
	KWizard::removePage( widget->parentWidget() );
}
//-----------------------------------------------
QWidget* KBearWizard::page( int index ) {
	QWidget* p = KWizard::page( index );
	if( index ) {
		return static_cast<KBearWizardPagePrivate*>( p )->child();
	}
	return 0L;
}
//-----------------------------------------------
void KBearWizard::setupGUI() {
//	resize( 547, 524 );
	setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)5, 0, 0, sizePolicy().hasHeightForWidth() ) );
	setCaption( i18n( "KBear Wizard" ) );
	setFocusPolicy( QWizard::WheelFocus );
	setSizeGripEnabled( false );

	QLabel* welcomeLabel = new QLabel( 0L, "welcomeLabel" );
	welcomeLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, 0, 0, welcomeLabel->sizePolicy().hasHeightForWidth() ) );
	welcomeLabel->setText( i18n( "<h1>Welcome to the KBear Wizard.</h1>"
												"<p>This Wizard will help you to setup KBear. Most users can just leave the settings to default.</p>"
												"<p>If you are behind a <b>firewall</b> you might want to load the Firewall plugin though.</p>"
												"<p>If there is something you don't understand, just hit the <b>whats this</b> button in the upper right corner. "
												"Then move the mouse to the place you have questions about and push the mouse button again. "
												"A help message will then be displayed at the mouse position explaining the specific area."
												"<p>For more extensive help push the help button in the lower right corner.</p>"
												"<p><b>Thank you for using KBear.</b></p>"
												"<p><b>The KBear Team.</b></p>" ) );
	welcomeLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignVCenter ) );

	addPage( welcomeLabel, QString::null );

	// signals and slots connections
	connect( this, SIGNAL( helpClicked() ), this, SLOT( slotHelp() ) );
}
//-----------------------------------------------
void KBearWizard::slotHelp(){
// here we point help to different sections depending on which page is chown
	KBearConfigWidgetIface* w = dynamic_cast<KBearConfigWidgetIface*>( page( indexOf( currentPage() ) ) );
	if( w  ) {
		KApplication::kApplication()->invokeHelp( w->helpSection(), "kbear");
	}
	else
		KApplication::kApplication()->invokeHelp( QString::fromLatin1( "configure-kbear" ), "kbear");

}
//-----------------------------------------------
