/*********************************************************************************
* C++ Implementation: pluginselectwidget.cpp
* Description:
*                              
* Begin : tis jan 15 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qheader.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <qlabel.h>
#include <qlayout.h>
#include <qlistview.h>
#include <qvgroupbox.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kconfigbase.h>
#include <kservice.h>
#include <ktrader.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "pluginselectwidget.h"

#include "pluginselectwidget.moc"
//-----------------------------------------------
class PluginSelectWidgetItem : public QCheckListItem {
	public:
		PluginSelectWidgetItem( QListView* parent, const QString& name, const QString& text, const QString& comment )
			:	QCheckListItem( parent, text, QCheckListItem::CheckBox ),
				m_name( name), m_comment( comment ), m_text( text )
		{
		}
	public:
		QString m_name;
		QString m_comment;
		QString m_text;
};
//-----------------------------------------------
PluginSelectWidget::PluginSelectWidget( QWidget* parent, const char* name )
	:	QWidget( parent, name )
{
	init();
}
//-----------------------------------------------
PluginSelectWidget::~PluginSelectWidget() {
}
//-----------------------------------------------
void PluginSelectWidget::init() {
	QVBoxLayout *layout = new QVBoxLayout(this);

	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>This page let you choose which plugins you want to be loaded. "
															"Just check/uncheck the plugins you want to load/unload.</p>" ) );
	infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	layout->addWidget( infoLabel );

//	QLabel* label = new QLabel( i18n("Plugins to load at startup:"), this );

	m_listView = new QListView(this);
	m_listView->setSorting(-1);
	m_listView->addColumn("");
	m_listView->setAcceptDrops( false );
	m_listView->setRootIsDecorated( false );
	m_listView->setSelectionMode( QListView::Single );
	m_listView->setAllColumnsShowFocus( false );
	m_listView->header()->hide();

	connect( m_listView, SIGNAL( selectionChanged( QListViewItem* ) ), this, SLOT( slotSelectionChanged( QListViewItem* ) ) );

//	layout->addWidget( label );
	layout->addWidget( m_listView );

	QVGroupBox* groupBox = new QVGroupBox( i18n("Description"), this, "groupBox"  );
	m_descriptionLabel = new QLabel( groupBox, "m_descriptionLabel" );
	m_descriptionLabel->setAlignment( AlignLeft | WordBreak );
	layout->addWidget( groupBox );

	KTrader::OfferList offers = KTrader::self()->query( QString::fromLatin1( "KBear/Plugin" ) );
	KConfig *config = kapp->config();
	KConfigGroupSaver cs( config, config->group() );
	config->setGroup("Plugins");
    
	for (KTrader::OfferList::ConstIterator it = offers.begin(); it != offers.end(); ++it) {
		QCheckListItem *item = new PluginSelectWidgetItem( m_listView, (*it)->name(), (*it)->genericName(), (*it)->comment() );
		item->setOn( config->readBoolEntry( (*it)->name(), true ) );
	}
	 layout->activate();

}
//-----------------------------------------------
void PluginSelectWidget::slotSelectionChanged( QListViewItem* i ) {
	if( ! i ) {
		m_descriptionLabel->setText( QString::null );
		return;
	}

	PluginSelectWidgetItem* item = static_cast<PluginSelectWidgetItem*>( i );
	m_descriptionLabel->setText( item->m_comment );
}
//-----------------------------------------------
void PluginSelectWidget::slotAccept() {
	KConfig* config = kapp->config();
	KConfigGroupSaver cs( config, config->group() );
	config->setGroup( "Plugins" );

	QListViewItemIterator listViewIter( m_listView );
	for( ; listViewIter.current() ; ++listViewIter ) {
		PluginSelectWidgetItem* item = static_cast<PluginSelectWidgetItem*>( listViewIter.current() );
		config->writeEntry( item->m_name, item->isOn() );
	}
	config->sync();
	emit accepted();
}
//-----------------------------------------------
