/*********************************************************************************
* C++ Implementation: uisettingswidget.cpp
* Description:
*
* Begin : tis mar 25 2003
* Author : Bjrn Sahlstrm <kbjorn@users.sourceforge.net> (C) 2003
* Copyright : See COPYING file that comes with this distribution
**********************************************************************************/


//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qfont.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qsizepolicy.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qwhatsthis.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <klocale.h>
#include <kapplication.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kconfigbase.h>

//////////////////////////////////////////////////////////////////////
// System specific include files
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "uisettingswidget.h"
#include "kmdidefines.h"
#include "misc.h"


#include "uisettingswidget.moc"

using namespace KBear;
//-----------------------------------------------
UISettingsWidget::UISettingsWidget( QWidget* parent,  const char* name )
    : KBearConfigWidgetIface( parent, name )
{
	setupGUI();
	readSettings();
}
//-----------------------------------------------
UISettingsWidget::~UISettingsWidget() {
}
//-----------------------------------------------
QString UISettingsWidget::helpSection() const {
	return QString::fromLatin1( "window-settings" );
}
//-----------------------------------------------
void UISettingsWidget::readSettings( bool defaultSettings ) {
	KConfig* config = kapp->config();
	KConfigGroupSaver( config, config->group() );
	if( defaultSettings ) {
		config->setGroup( "UI" );
		config->deleteEntry( QString::fromLatin1("GUIStyle" ) );
		config->setGroup( "View Options" );
		config->deleteEntry( QString::fromLatin1("MDI mode" ) );
		config->deleteEntry( QString::fromLatin1("Remember Child Positions" ) );
		config->deleteEntry( QString::fromLatin1("ChildFrameMode" ) );
		config->deleteEntry( QString::fromLatin1("Maximized Childframes" ) );
		config->deleteEntry( QString::fromLatin1("Auto ChildFrameMode" ) );
		config->setGroup( "View Settings" );
		config->deleteEntry( QString::fromLatin1("Show TreeView" ) );
		config->deleteEntry( QString::fromLatin1("Child ToolBar" ) );
		config->deleteEntry( QString::fromLatin1("Child Path ToolBar" ) );
		config->deleteEntry( QString::fromLatin1("Child StatusBar" ) );
		config->deleteEntry( QString::fromLatin1("Child InfoBar" ) );
		config->sync();
	}
	config->setGroup( "UI" );
	bool classic = config->readEntry( "GUIStyle", "KMdi" ) == QString::fromLatin1("Classic");
	config->setGroup( "View Options" );
	if( classic ) {
		m_classicModeRadioButton->setChecked( true );
	}
	else {
		unsigned int mdiMode = config->readUnsignedNumEntry( "MDI mode", KMdi::ChildframeMode );
		switch( mdiMode ) {
			case KMdi::ToplevelMode:
				m_topLevelRadioButton->setChecked( true );
				break;
			case KMdi::TabPageMode:
				m_tabPageRadioButton->setChecked( true );
				break;
			default:
				m_childFrameRadioButton->setChecked( true );
		}
	}
	m_rememberPosCheckBox->setChecked( config->readBoolEntry( "Remember Child Positions", true ) );

	setChildFrameMode( config->readUnsignedNumEntry( "ChildFrameMode", KBear::TileVertically ) );

	m_maximizedChildFrameMode->setChecked( config->readBoolEntry( "Maximized Childframes", false ) );

	m_useAutoChildFrameMode->setChecked( config->readBoolEntry( "Auto ChildFrameMode", true ) );

	config->setGroup( "View Settings" );
	QString tmp = QString::fromLatin1("Detail");
	QString viewType = config->readEntry("View Style", tmp );
	if( viewType == tmp )
		m_detailedView->setChecked( true );
	else
		m_shortView->setChecked( true );

	m_treeViewCheckBox->setChecked( config->readBoolEntry("Show TreeView", true) );

	m_childToolBarCheckBox->setChecked( config->readBoolEntry("Child ToolBar", true) );
	m_childPathToolBarCheckBox->setChecked( config->readBoolEntry("Child Path ToolBar", true) );
	m_childStatusBarCheckBox->setChecked( config->readBoolEntry("Child StatusBar", true) );
	m_childInfoBarCheckBox->setChecked( config->readBoolEntry("Child InfoBar", true) );

	slotViewSelect();
}
//-----------------------------------------------
void UISettingsWidget::saveSettings() {
	KConfig* config = kapp->config();
	KConfigGroupSaver( config, config->group() );
	config->setGroup( "View Options" );
	if( m_topLevelRadioButton->isChecked() )
		config->writeEntry( "MDI mode", KMdi::ToplevelMode);
	else if( m_tabPageRadioButton->isChecked() )
		config->writeEntry( "MDI mode", KMdi::TabPageMode);
	else
		config->writeEntry( "MDI mode", KMdi::ChildframeMode);

	config->writeEntry( "ChildFrameMode", getChildFrameMode() );
	config->writeEntry( "Remember Child Positions", m_rememberPosCheckBox->isChecked() );
	config->writeEntry( "Maximized Childframes", m_maximizedChildFrameMode->isChecked() );
	config->writeEntry( "Auto ChildFrameMode", m_useAutoChildFrameMode->isChecked() );

	config->setGroup( "View Settings" );
	if( m_detailedView->isChecked() )
		config->writeEntry("View Style", QString::fromLatin1("Detail") );
	else
		config->writeEntry("View Style", QString::fromLatin1("Simple") );

	config->writeEntry("Show TreeView", m_treeViewCheckBox->isChecked() );
	config->writeEntry("Child ToolBar", m_childToolBarCheckBox->isChecked() );
	config->writeEntry("Child Path ToolBar", m_childPathToolBarCheckBox->isChecked() );
	config->writeEntry("Child StatusBar", m_childStatusBarCheckBox->isChecked() );
	config->writeEntry("Child InfoBar", m_childInfoBarCheckBox->isChecked() );

	config->setGroup( "UI" );
	if( m_classicModeRadioButton->isChecked() )
		config->writeEntry("GUIStyle", QString::fromLatin1("Classic") );
	else
		config->writeEntry("GUIStyle", QString::fromLatin1("KMdi") );

	config->sync();

	emit newSettings();
}
//-----------------------------------------------
void UISettingsWidget::setupGUI() {
    QVBoxLayout* UISettingsWidgetLayout = new QVBoxLayout( this, 11, 6, "UISettingsWidgetLayout");

	QLabel* infoLabel = new QLabel( this );
	infoLabel->setText( i18n( "<p>This page let you setup the UI (User Interface) of KBear. "
			       "The first tab concerns the main window and the second the child windows. "
			       "If you are uncertain, just leave it as it is..</p>" ) );
  infoLabel->setAlignment( int( QLabel::WordBreak | QLabel::AlignTop ) );

	 UISettingsWidgetLayout->addWidget( infoLabel );

	 QTabWidget* tabWidget = new QTabWidget( this, "tabWidget" );

	 UISettingsWidgetLayout->addWidget( tabWidget );

	 //////////////////////////////////////////////////////////////////////
	 // Main window settings
	 //////////////////////////////////////////////////////////////////////
	 QWidget * mainUIWidget = new QWidget( tabWidget, "mainUIWidget" );
    QVBoxLayout* mainUIWidgetLayout = new QVBoxLayout( mainUIWidget, 11, 6, "mainUIWidgetLayout");

	 QButtonGroup* modeButtonGroup = new QButtonGroup( mainUIWidget, "modeButtonGroup" );
	 modeButtonGroup->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)0, 0, 0, modeButtonGroup->sizePolicy().hasHeightForWidth() ) );
    modeButtonGroup->setColumnLayout(0, Qt::Vertical );
    modeButtonGroup->layout()->setSpacing( 6 );
    modeButtonGroup->layout()->setMargin( 11 );
    modeButtonGroup->setTitle( i18n( "Major User Interface" ) );
    QVBoxLayout* modeButtonGroupLayout = new QVBoxLayout( modeButtonGroup->layout() );
    modeButtonGroupLayout->setAlignment( Qt::AlignTop );

    m_topLevelRadioButton = new QRadioButton( modeButtonGroup, "m_topLevelRadioButton" );
    m_topLevelRadioButton->setText( i18n( "TopLevel window mode." ) );
    QString tmp = i18n( "Check this option if you want KBear to start in TopLevel mode by default." );
	 QToolTip::add( m_topLevelRadioButton, tmp );
    QWhatsThis::add( m_topLevelRadioButton, tmp );
    modeButtonGroupLayout->addWidget( m_topLevelRadioButton );

	 m_childFrameRadioButton = new QRadioButton( modeButtonGroup, "m_childFrameRadioButton" );
    m_childFrameRadioButton->setText( i18n( "ChildFrame window mode" ) );
    m_childFrameRadioButton->setChecked( true );
    tmp = i18n( "Check this option if you want KBear to start in ChildFrame mode by default." );
    QToolTip::add( m_childFrameRadioButton, tmp );
    QWhatsThis::add( m_childFrameRadioButton, tmp );
    modeButtonGroupLayout->addWidget( m_childFrameRadioButton );

    m_tabPageRadioButton = new QRadioButton( modeButtonGroup, "m_tabPageRadioButton" );
    m_tabPageRadioButton->setText( i18n( "Tabbed pages mode" ) );
    tmp = i18n( "Check this option if you want KBear to start in TabPage mode by default." );
    QToolTip::add( m_tabPageRadioButton, tmp );
    QWhatsThis::add( m_tabPageRadioButton, tmp );
    modeButtonGroupLayout->addWidget( m_tabPageRadioButton );

    m_classicModeRadioButton = new QRadioButton( modeButtonGroup, "m_classicModeRadioButton" );
    m_classicModeRadioButton->setText( i18n( "Classic FTP mode" ) );
    tmp = i18n( "Check this option if you want KBear to start in a classic FTP mode by default." );
    QToolTip::add( m_classicModeRadioButton, tmp );
    QWhatsThis::add( m_classicModeRadioButton, tmp );
    modeButtonGroupLayout->addWidget( m_classicModeRadioButton );

    QLabel* textLabel1 = new QLabel( i18n( "Please note that a change to and from Classic FTP mode requires a restart of the application." ), modeButtonGroup, "textLabel1" );
    textLabel1->setAlignment( int( QLabel::WordBreak | textLabel1->alignment() ) );
	 QFont font = textLabel1->font();
	 font.setItalic( true );
	 textLabel1->setFont( font );
	 modeButtonGroupLayout->addWidget( textLabel1 );

 	 m_rememberPosCheckBox = new QCheckBox( modeButtonGroup, "m_rememberPosCheckBox" );
  	 m_rememberPosCheckBox->setText( i18n( "Remember window positions in TopLevel mode." ) );
    m_rememberPosCheckBox->setChecked( TRUE );
    modeButtonGroupLayout->addWidget( m_rememberPosCheckBox );

	mainUIWidgetLayout->addWidget( modeButtonGroup );

	QSpacerItem* spacer = new QSpacerItem( 20, 41, QSizePolicy::Minimum, QSizePolicy::Expanding );
	mainUIWidgetLayout->addItem( spacer );
	mainUIWidgetLayout->activate();

	 tabWidget->addTab( mainUIWidget, i18n( "Main window" ) );

	 //////////////////////////////////////////////////////////////////////
	 // Child window settings
	 //////////////////////////////////////////////////////////////////////
	 QWidget * childUIWidget = new QWidget( tabWidget, "childUIWidget" );
    QVBoxLayout* childUIWidgetLayout = new QVBoxLayout( childUIWidget, 11, 6, "childUIWidgetLayout");

	 QButtonGroup* viewModeButtonGroup = new QButtonGroup( childUIWidget, "viewModeButtonGroup" );
    viewModeButtonGroup->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, viewModeButtonGroup->sizePolicy().hasHeightForWidth() ) );
    viewModeButtonGroup->setFrameShape( QButtonGroup::Box );
    viewModeButtonGroup->setColumnLayout(0, Qt::Vertical );
    viewModeButtonGroup->layout()->setSpacing( 6 );
    viewModeButtonGroup->layout()->setMargin( 11 );
    viewModeButtonGroup->setTitle( i18n( "Default view settings" ) );
    QGridLayout* viewModeButtonGroupLayout = new QGridLayout( viewModeButtonGroup->layout() );
    viewModeButtonGroupLayout->setAlignment( Qt::AlignTop );

    m_detailedView= new QRadioButton( viewModeButtonGroup, "m_detailedView" );
    m_detailedView->setText( i18n( "Detailed View" ) );
    m_detailedView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_detailedView->sizePolicy().hasHeightForWidth() ) );

    viewModeButtonGroupLayout->addWidget( m_detailedView, 0, 0 );

    m_shortView = new QRadioButton( viewModeButtonGroup, "m_detailedView" );
    m_shortView->setText( i18n( "Short View" ) );
    m_shortView->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_shortView->sizePolicy().hasHeightForWidth() ) );

	 viewModeButtonGroupLayout->addWidget( m_shortView, 1, 0 );
    m_viewTypePicture = new QLabel( viewModeButtonGroup, "m_viewTypePicture" );
	 m_viewTypePicture->setScaledContents( false );

	 viewModeButtonGroupLayout->addMultiCellWidget( m_viewTypePicture, 0, 1, 1, 1 );

	 childUIWidgetLayout->addWidget( viewModeButtonGroup );

	 QButtonGroup* childFrameModeButtonGroup = new QButtonGroup( childUIWidget, "childFrameModeButtonGroup" );
    childFrameModeButtonGroup->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, childFrameModeButtonGroup->sizePolicy().hasHeightForWidth() ) );
    childFrameModeButtonGroup->setFrameShape( QButtonGroup::Box );
    childFrameModeButtonGroup->setColumnLayout(0, Qt::Vertical );
    childFrameModeButtonGroup->layout()->setSpacing( 6 );
    childFrameModeButtonGroup->layout()->setMargin( 11 );
    childFrameModeButtonGroup->setTitle( i18n( "Set default ChildFrame mode" ) );
    QGridLayout* childFrameModeButtonGroupLayout = new QGridLayout( childFrameModeButtonGroup->layout() );
    childFrameModeButtonGroupLayout->setAlignment( Qt::AlignTop );

    m_expandHorizontal = new QRadioButton( childFrameModeButtonGroup, "m_expandHorizontal" );
    m_expandHorizontal->setText( i18n( "Expand horizontal" ) );
    m_expandHorizontal->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_expandHorizontal->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addMultiCellWidget( m_expandHorizontal, 3, 3, 0, 1 );

    m_expandVertical = new QRadioButton( childFrameModeButtonGroup, "m_expandVertical" );
    m_expandVertical->setText( i18n( "Expand vertical" ) );
    m_expandVertical->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_expandVertical->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_expandVertical, 2, 0 );

    m_pragmasTile = new QRadioButton( childFrameModeButtonGroup, "m_pragmasTile" );
    m_pragmasTile->setText( i18n( "Tile overlapped" ) );
    m_pragmasTile->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_pragmasTile->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_pragmasTile, 1, 1 );

    m_tileVertically = new QRadioButton( childFrameModeButtonGroup, "m_tileVertically" );
    m_tileVertically->setText( i18n( "Tile vertically" ) );
    m_tileVertically->setChecked( true );
    m_tileVertically->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_tileVertically->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_tileVertically, 2, 1 );

    m_cascade = new QRadioButton( childFrameModeButtonGroup, "m_cascade" );
    m_cascade->setText( i18n( "Cascade windows" ) );
    m_cascade->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_cascade->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_cascade, 0, 0 );

    m_cascadeMaximized = new QRadioButton( childFrameModeButtonGroup, "m_cascadeMaximized" );
    m_cascadeMaximized->setText( i18n( "Cascade maximized" ) );
    m_cascadeMaximized->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_cascadeMaximized->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_cascadeMaximized, 1, 0 );

    m_anodinesTile = new QRadioButton( childFrameModeButtonGroup, "m_anodinesTile" );
    m_anodinesTile->setText( i18n( "Tile non-overlapped" ) );
    m_anodinesTile->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)5, (QSizePolicy::SizeType)0, 0, 0, m_anodinesTile->sizePolicy().hasHeightForWidth() ) );

    childFrameModeButtonGroupLayout->addWidget( m_anodinesTile, 0, 1 );

    QFrame* Line1 = new QFrame( childFrameModeButtonGroup, "Line1" );
    Line1->setFrameShape( QFrame::HLine );
    Line1->setFrameShadow( QFrame::Sunken );
    Line1->setFrameShape( QFrame::HLine );

    childFrameModeButtonGroupLayout->addMultiCellWidget( Line1, 4, 4, 0, 1 );

    m_maximizedChildFrameMode = new QRadioButton( childFrameModeButtonGroup, "m_maximizedChildFrameMode" );
    m_maximizedChildFrameMode->setText( i18n( "Maximized ChildFrame mode" ) );

    childFrameModeButtonGroupLayout->addMultiCellWidget( m_maximizedChildFrameMode, 5, 5, 0, 1 );

    QFrame* Line2 = new QFrame( childFrameModeButtonGroup, "Line2" );
    Line2->setFrameShape( QFrame::HLine );
    Line2->setFrameShadow( QFrame::Sunken );
    Line2->setFrameShape( QFrame::HLine );

    childFrameModeButtonGroupLayout->addMultiCellWidget( Line2, 6, 6, 0, 1 );

    m_useAutoChildFrameMode = new QCheckBox( childFrameModeButtonGroup, "m_useAutoChildFrameMode" );
    m_useAutoChildFrameMode->setText( i18n( "Use automatic tiling of childviews when in ChildFrame mode." ) );
    m_useAutoChildFrameMode->setChecked( true );

    childFrameModeButtonGroupLayout->addMultiCellWidget( m_useAutoChildFrameMode, 7, 7, 0, 1 );

	 childUIWidgetLayout->addWidget( childFrameModeButtonGroup );

    QButtonGroup* visibleSettingGroupBox = new QButtonGroup( childUIWidget, "visibleSettingGroupBox" );
    visibleSettingGroupBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, visibleSettingGroupBox->sizePolicy().hasHeightForWidth() ) );
    visibleSettingGroupBox->setFrameShape( QGroupBox::Box );
    visibleSettingGroupBox->setColumnLayout(0, Qt::Vertical );
    visibleSettingGroupBox->layout()->setSpacing( 6 );
    visibleSettingGroupBox->layout()->setMargin( 11 );
    visibleSettingGroupBox->setTitle( i18n( "Show ChildView Components" ) );
    QGridLayout* visibleSettingGroupBoxLayout = new QGridLayout( visibleSettingGroupBox->layout() );
    visibleSettingGroupBoxLayout->setAlignment( Qt::AlignTop );

    m_childStatusBarCheckBox = new QCheckBox( visibleSettingGroupBox, "m_childStatusBarCheckBox" );
    m_childStatusBarCheckBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, m_childStatusBarCheckBox->sizePolicy().hasHeightForWidth() ) );
    m_childStatusBarCheckBox->setText( i18n( "Show Statusbar" ) );
    m_childStatusBarCheckBox->setAutoResize( true );
    m_childStatusBarCheckBox->setChecked( true );
    tmp = i18n( "Check this option if you want the Statusbar of the child views to be visible by default." );
    QToolTip::add( m_childStatusBarCheckBox, tmp );
    QWhatsThis::add( m_childStatusBarCheckBox, tmp );

    visibleSettingGroupBoxLayout->addWidget( m_childStatusBarCheckBox, 1, 0 );

    m_childToolBarCheckBox = new QCheckBox( visibleSettingGroupBox, "m_childToolBarCheckBox" );
    m_childToolBarCheckBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, m_childToolBarCheckBox->sizePolicy().hasHeightForWidth() ) );
    m_childToolBarCheckBox->setText( i18n( "Show Toolbar" ) );
    m_childToolBarCheckBox->setAutoResize( true );
    m_childToolBarCheckBox->setChecked( true );
    tmp = i18n( "Check this option if you want the Toolbar of the child views to be visible by default." );
    QToolTip::add( m_childToolBarCheckBox, tmp );
    QWhatsThis::add( m_childToolBarCheckBox, tmp );

    visibleSettingGroupBoxLayout->addWidget( m_childToolBarCheckBox, 0, 0 );

    m_childPathToolBarCheckBox = new QCheckBox( visibleSettingGroupBox, "m_childPathToolBarCheckBox" );
    m_childPathToolBarCheckBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, m_childPathToolBarCheckBox->sizePolicy().hasHeightForWidth() ) );
    m_childPathToolBarCheckBox->setText( i18n( "Show Path Toolbar" ) );
    m_childPathToolBarCheckBox->setAutoResize( true );
    m_childPathToolBarCheckBox->setChecked( true );
    tmp = i18n( "Check this option if you want the Path Toolbar of the child views to be visible by default." );
    QToolTip::add( m_childPathToolBarCheckBox, tmp );
    QWhatsThis::add( m_childPathToolBarCheckBox, tmp );

    visibleSettingGroupBoxLayout->addWidget( m_childPathToolBarCheckBox, 0, 1 );

    m_childInfoBarCheckBox = new QCheckBox( visibleSettingGroupBox, "m_childInfoBarCheckBox" );
    m_childInfoBarCheckBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, m_childInfoBarCheckBox->sizePolicy().hasHeightForWidth() ) );
    m_childInfoBarCheckBox->setText( i18n( "Show Infobar" ) );
    m_childInfoBarCheckBox->setAutoResize( true );
    m_childInfoBarCheckBox->setChecked( true );
    tmp = i18n( "Check this option if you want the Informationbar at the bottom of the child views to be visible by default." );
    QToolTip::add( m_childInfoBarCheckBox, tmp );
    QWhatsThis::add( m_childInfoBarCheckBox, tmp );

    visibleSettingGroupBoxLayout->addWidget( m_childInfoBarCheckBox, 1, 1 );

    m_treeViewCheckBox = new QCheckBox( visibleSettingGroupBox, "m_treeViewCheckBox" );
    m_treeViewCheckBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, m_treeViewCheckBox->sizePolicy().hasHeightForWidth() ) );
    m_treeViewCheckBox->setText( i18n( "Show Tree View" ) );
    m_treeViewCheckBox->setAutoResize( true );
    m_treeViewCheckBox->setChecked( true );
    tmp = i18n( "Check this option if you want the Tree View  to be visible by default." );
    QToolTip::add( m_treeViewCheckBox, tmp );
    QWhatsThis::add( m_treeViewCheckBox, tmp );

    visibleSettingGroupBoxLayout->addWidget( m_treeViewCheckBox, 2, 0 );

    QLabel* dummyLabel = new QLabel( QString::null, visibleSettingGroupBox, "dummyLabel" );
    dummyLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, 0, 0, dummyLabel->sizePolicy().hasHeightForWidth() ) );
    dummyLabel->setAutoResize( true );

    visibleSettingGroupBoxLayout->addWidget( dummyLabel, 2, 1 );

	 childUIWidgetLayout->addWidget( visibleSettingGroupBox );
    spacer = new QSpacerItem( 20, 41, QSizePolicy::Minimum, QSizePolicy::Expanding );
    childUIWidgetLayout->addItem( spacer );
	 childUIWidgetLayout->activate();

	 tabWidget->addTab( childUIWidget, i18n( "Child windows" ) );

	 UISettingsWidgetLayout->activate();

	 connect( m_detailedView, SIGNAL( clicked() ), this, SLOT( slotViewSelect() ) );
	 connect( m_shortView, SIGNAL( clicked() ), this, SLOT( slotViewSelect() ) );
}
//-----------------------------------------------
void UISettingsWidget::setChildFrameMode( unsigned int mode ) {
	switch( mode ) {
		case KBear::Cascade:
			m_cascade->setChecked( true);break;
		case KBear::CascadeMaximized:
			m_cascadeMaximized->setChecked( true );break;
		case KBear::ExpandVertical:
			m_expandVertical->setChecked( true );break;
		case KBear::ExpandHorizontal:
			m_expandHorizontal->setChecked( true );break;
		case KBear::AnodinesTile:
			m_anodinesTile->setChecked( true );break;
		case KBear::PragmasTile:
			m_pragmasTile->setChecked( true );break;
		case KBear::TileVertically:
			m_tileVertically->setChecked( true );break;
	}
}
//-----------------------------------------------
unsigned int UISettingsWidget::getChildFrameMode() {
	if( m_cascade->isChecked() )
		return KBear::Cascade;
	else if( m_cascadeMaximized->isChecked() )
		return	KBear::CascadeMaximized;
	else if( m_expandVertical->isChecked() )
		return KBear::ExpandVertical;
	else if( m_expandHorizontal->isChecked() )
		return KBear::ExpandHorizontal;
	else if( m_anodinesTile->isChecked() )
		return KBear::AnodinesTile;
	else if( m_pragmasTile->isChecked() )
		return KBear::PragmasTile;
	else if( m_tileVertically->isChecked() )
		return KBear::TileVertically;

	return KBear::NoMode;
}
//-----------------------------------------------
void UISettingsWidget::slotViewSelect() {
	if( m_detailedView->isOn() )
		m_viewTypePicture->setPixmap( QPixmap( locate("appdata","detailview_thumb.jpg") ) );
	else
		m_viewTypePicture->setPixmap( QPixmap( locate("appdata","iconview_thumb.jpg") ) );

}
//-----------------------------------------------
