/***************************************************************************
                          alarmdlgimpl.h  -  description
                             -------------------
    begin                : Sat Oct 13 2001
    copyright           : (C) 2001-2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ALARMDLGIMPL_H
#define ALARMDLGIMPL_H

#include "alarmdlg.h"
#include "birthdayoptions.h"
#include "birthdayscanner.h"
#include "birthdayitem.h"

#include <qlistview.h>


/**
* @brief Implementation of the alarm dialog base class.
* @author Jan Hambrecht
*/
class AlarmDlgImpl : public AlarmDlg  
{
	Q_OBJECT
public: 
	/** @brief The constructor. */
	AlarmDlgImpl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	
	/** @brief The destructor. */
	~AlarmDlgImpl();
	
	/** 
	* @brief Initializes the event dialog. 
	* @param options pointer to options object to initialize dialog with
	* @return true if initializing was sucessful and pending events are found, else false
	*/
	bool init( BirthdayOptions *options );
	
protected: // Protected methods
	
	/** @brief The event handler for an resize event. */
	void resizeEvent( QResizeEvent* );
	
	/** @brief The event handler for a show event. */
	void showEvent( QShowEvent * );
	
	/** @brief Fills birthday events into the birthday event list. */
	void fillBirthday();
	
	/** @brief Fills anniversary events into anniversary event list. */
	void fillAnniversary();

private: // Private methods
	
	/** @brief Calculates width of columns in listview. */
	void arrangeColumns();
	
	/** @brief The event scanner. */
	BirthdayScanner m_scanner;
	
	/** @brief The options object. */
	BirthdayOptions *m_options;
	
public slots:
   /**
   * @brief Receives mouse click event from listview.
   * @param item the list item the user has clicked on
   */
   void slotClicked(QListViewItem* item);
};

#endif
