/***************************************************************************
                          birthdayitem.h  -  description
                             -------------------
    begin                : Tue Mar 5 2002
    copyright            : (C) 2002,2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BIRTHDAYITEM_H
#define BIRTHDAYITEM_H

#include <qlistview.h>
#include <qstring.h>
#include <qcolor.h>

#include "birthdayeventdata.h"

/**
* @brief A listview item to show the data of a pending event.
* @author Jan Hambrecht
*/
class BirthdayItem : public QListViewItem  
{
public:
	/** @brief The constructor. */
	BirthdayItem( QListView *parent, BirthdayEventData &event );
	
	/** @brief The destructor. */
	~BirthdayItem();
	
	/** @brief The reimplemented paint method. */
	virtual void paintCell( QPainter *p, const QColorGroup & cg, int column, int width, int alignment );
	
	/** @brief The reimplemented key method for sorting date column. */
	virtual QString key( int column, bool ascending ) const;
	
	/* @brief Retrieves the UID of the corresponding addressee. */
	QString getUid();
	
private: // Private attributes
	
	/** @brief The text color. */
	QColor m_color;
	
	/** @brief The sort key. */
	QString m_key;
	
	/** @brief The addressee uid. */
	QString m_uid;
};

#endif
