/***************************************************************************
                          kbirthday.cpp  -  description
                             -------------------
    begin                : Thu Oct 11 17:27:47 CEST 2001
    copyright           : (C) 2001-2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbirthday.h"
#include <klocale.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include <qglobal.h>
#include <qtooltip.h>
#include <qdatetime.h>

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif

extern "C"
{
	KPanelApplet* init( QWidget *parent, const QString configFile)
	{
		KGlobal::locale()->insertCatalogue("kbirthday");
		return new KBirthday(configFile, KPanelApplet::Normal, 0, parent, "kbirthday");
	}
}

KBirthday::KBirthday(const QString& configFile, Type type, int actions, QWidget *parent, const char *name)
       : KPanelApplet(configFile, type, actions, parent, name)
{
	setBackgroundMode(X11ParentRelative);
	// create icon
	m_icon = new QPixmap( birthday );
	setIcon( *m_icon );

	// create popup menu
	m_popup = new KPopupMenu();
	m_popup->insertTitle( *m_icon, "KBirthday" );
	m_popup->insertItem( i18n("&Show Events"), ITEM_ALARM );
	m_popup->insertItem( i18n("Address&book"), ITEM_ADDRESSBOOK );
	m_popup->insertSeparator();
	m_popup->insertItem( i18n("&About"), ITEM_ABOUT );
	m_popup->insertItem(SmallIcon("configure"), i18n("&Preferences..."), ITEM_CONFIG);
	connect( m_popup, SIGNAL(activated(int)), this, SLOT(popupClick(int)));

	// applet button
	m_button = new QToolButton( this );
	m_button->setBackgroundMode(X11ParentRelative);
	m_button->setPixmap( *m_icon );
	m_button->setFixedSize( width(), height() );
	m_button->setOn( FALSE );
	QToolTip::add(m_button, "KBirthday");
	connect( m_button, SIGNAL(clicked()), this, SLOT( showPopup()));

	// about data
	m_about = new KAboutData( "kbirthday", "KBirthday", VERSION,
	I18N_NOOP("KBirthday reminds you of birthdays and anniversaries\nfrom your kde addressbook."),
	KAboutData::License_GPL, "(c) 2002,2003, Jan Hambrecht");
	m_about->addAuthor("Jan Hambrecht", 0, "jaham@gmx.net");
	m_about->setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names") ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));
	
	m_options = new BirthdayOptions();
	m_options->load();

	m_timer = new QTimer(this);
	connect( m_timer, SIGNAL(timeout()), this, SLOT(timerDone()) );
}

KBirthday::~KBirthday()
{
	delete m_icon;
	delete m_popup;
	delete m_button;
	delete m_options;
	delete m_about;
	delete m_timer;
}

void KBirthday::about()
{
	KAboutApplication dlg( m_about );
	dlg.exec();
}

int KBirthday::widthForHeight( int ) const
{
	return APPLET_SIZE;
}

int KBirthday::heightForWidth( int ) const
{
	return APPLET_SIZE;
}

void KBirthday::resizeEvent( QResizeEvent * )
{
	m_button->setFixedSize( width(), height() );
}

void KBirthday::popupClick(int id)
{
	switch ( id )
	{
		case -1:
		break;
		case ITEM_CONFIG :
			showPreferences();
		break;
		case ITEM_ABOUT :
			about();
		break;
		case ITEM_ALARM :
			showEventsDlg();
		break;
		case ITEM_ADDRESSBOOK:
		    launchAddressBook();
		break;
	}
}

void KBirthday::showPreferences(void)
{
	ConfDlgImpl *dlg = new ConfDlgImpl( 0, "confdlg", true );
	dlg->setOptions( *m_options );
	if( dlg->exec() )
	{
		dlg->getOptions( *m_options );
		m_options->save();
	}
	delete dlg;
}

void KBirthday::mousePressEvent(QMouseEvent *e)
{
	if ( e->button() == LeftButton || e->button() == RightButton )
	{
		showPopup();
 	}
}

void KBirthday::arrangeIcon(void)
{
	m_button->setFixedSize( height(), width() );
}

void KBirthday::showPopup()
{
	QPoint p = mapToGlobal( QPoint( 0, 0 ) );
	p.setY( p.y() - m_popup->sizeHint().height() );
	m_popup->exec( p );
	m_button->setOn( FALSE );
}

bool KBirthday::showEventsDlg( bool showMessage )
{
	bool ret;
	ret = m_alarm.init( m_options );
	if( ret )
	{
		if( m_alarm.isHidden() )
		{
			m_alarm.show();
		}
		else if( m_alarm.isMinimized() )
		{
#if QT_VERSION >= 0x030100
			m_alarm.setShown( FALSE );
#endif
			m_alarm.showNormal();
		}
	}
	else
	{
		if( showMessage )
			KMessageBox::information(0, i18n( "No Events in last %1 and next %2 days." ).arg( m_options->DaysPassed() ).arg( m_options->DaysComing() ) );
	}
	return ret;
}

void KBirthday::showEvent( QShowEvent * )
{
	if( m_options->ShowOnStartup() )
		showEventsDlg( false );

	QDateTime now = QDateTime::currentDateTime();
	QDateTime midnight = QDateTime(now.date().addDays(1), QTime(0,0));

	int secondsToMidnight = now.secsTo(midnight);
	m_timer->start( secondsToMidnight * 1000 );
}

void KBirthday::launchAddressBook()
{
	KProcess proc;
	proc << "kaddressbook";
	if( proc.start() )
	{
		proc.detach();
	}
}

void KBirthday::timerDone()
{
	// Timeout of one day
	m_timer->start( 60 * 60 * 24 * 1000 );
	
	// only show pending events at daybreak if enabled in options
	if( m_options->ShowAtDaybreak() )
		showEventsDlg( false );
}
