/***************************************************************************
                          kbirthday.h  -  description
                             -------------------
    begin                : Thu Oct 11 17:27:47 CEST 2001
    copyright           : (C) 2001-2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBIRTHDAY_H
#define KBIRTHDAY_H

#include <kapp.h>
#include <kpanelapplet.h>
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <kaboutapplication.h>

#include <qstring.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qtimer.h>

#include "confdlgimpl.h"
#include "alarmdlgimpl.h"

#define ICON_SIZE 20
#define APPLET_SIZE 24

/* XPM */
static const char *birthday[]={
"20 20 6 1",
". c None",
"# c #000000",
"d c #0058c0",
"c c #58a8ff",
"a c #a8dcff",
"b c #ffc0c0",
"....................",
"......#############.",
".....#aaaaabaaaaaa#.",
"....#aaaaabaaaaaac#.",
"...#bbbbbbbbbbbbcc#.",
"..#aaaaabaaaaaabcc#.",
".#aaaaabaaaaaacbcc#.",
".#dddddbdddddccbcc#.",
".#dddddbdddddccbcb#.",
".#dddddbdddddccbbc#.",
".#dddddbdddddccbcc#.",
".#dddddbdddddcbbcc#.",
".#bbbbbbbbbbbbcbcc#.",
".#dddddbdddddccbcc#.",
".#dddddbdddddccbc#..",
".#dddddbdddddccb#...",
".#dddddbdddddcc#....",
".#dddddbdddddc#.....",
".#############......",
"...................."};

class KBirthday : public KPanelApplet
{
Q_OBJECT
public:
	
	/**
	* @brief Constructs a @ref KPanelApplet just like any other widget.
	*
	* @param configFile The configFile handed over in the factory function.
	* @param Type The applet @ref type().
	* @param actions Standard RMB menu actions supported by the applet (see @ref action() ).
	* @param parent The pointer to the parent widget handed over in the factory function.
	* @param name A Qt object name for your applet.
	**/
	KBirthday(const QString& configFile, Type t = Normal, int actions = 0, QWidget *parent = 0, const char *name = 0);
	
	/** @brief The destructor */
	~KBirthday();
	
	/**
	* @brief Retrieve a suggested width for a given height.
	*
	* Every applet should reimplement this function.
	*
	* Depending on the panel orientation the height (horizontal panel) or the
	* width (vertical panel) of the applets is fixed.
	* The exact values of the fixed size component depend on the panel size.
	*
	* On a horizontal panel the applet height is fixed, the panel will
	* call @ref widthForHeight(int height) with @p height
	* equal to 'the fixed applet height'
	* when laying out the applets.
	*
	* The applet can now choose the other size component (width)
	* based on the given height.
	*
	* The width you return is granted.
	**/
	int widthForHeight( int height ) const;
	
	/**
	* @brief Retrieve a suggested height for a given width.
	*
	* Every applet should reimplement this function.
	*
	* Depending on the panel orientation the height (horizontal panel) or the
	* width (vertical panel) of the applets is fixed.
	* The exact values of the fixed size component depend on the panel size.
	*
	* On a vertical panel the applet width is fixed, the panel will
	* call @ref heightForWidth(int width) with @p width
	* equal to 'the fixed applet width'
	* when laying out the applets.
	*
	* The applet can now choose the other size component (height)
	* based on the given width.
	*
	* The height you return is granted.
	**/
	int heightForWidth( int width) const;
	
	/**
	* @brief Is called when the user selects "About" from the applets RMB menu.
	* Reimplement this function to launch a about dialog.
	*
	* Note that this is called only when your applet supports the About action.
	* See @ref Action and @ref KPanelApplet().
	**/
	void about();
	
	/** @brief Launches the KDE addressbook. */
	void launchAddressBook();

protected:

	/** @brief Is called when the applet was resized. */
	void resizeEvent( QResizeEvent* );
	
	/** @brief Is called when the applet is shown. */
	void showEvent( QShowEvent *e );

private:
	
	/** @brief The main popup menu. */
	KPopupMenu *m_popup;
	
	/** @brief The icon pixmap. */
	QPixmap *m_icon;
	
	/** @brief The button displaying the icon. */
	QToolButton *m_button;
	
	/** @brief The configuration options. */
	BirthdayOptions *m_options;
	
	/** @brief The about data. */
	KAboutData *m_about;
	
	/** @brief The alarm dialog. */
	AlarmDlgImpl m_alarm;
	
	/** @brief A timer to popup pending events at daybreak. **/
	QTimer *m_timer;
	
	/* @brief The identifiers for the menu items. */
	enum MENUITEMS { ITEM_CONFIG = 1, ITEM_ALARM, ITEM_ABOUT, ITEM_ADDRESSBOOK };
	
private slots: // Private slots
	
	/** 
	* @brief The event handler for a popup menu click.
	* @param id The ID of the clicked menu item. 
	*/
	void popupClick(int id);
	
	/** @brief Shows the  popup menu. */
	void showPopup();
	
	/** @brief The timer event handler. */
	void timerDone();

private: // Private methods
	
	/** @brief Shows the configuration dialog. */
	void showPreferences(void);
	
	/** 
	* @brief The event handler for a mouse click on the applet. 
	* @param e The triggering mouse event.
	*/
	void mousePressEvent(QMouseEvent *e);
	
	/** @brief Arranges the button with the icon to cover the whole applet. */
	void arrangeIcon(void);
	
	/**  
	* @brief Shows the alarm dialog. 
	* @param showMessage Flag, which controls if a messagebox is shown when no events are pending.
	*/
	bool showEventsDlg( bool showMessage = true );
};

#endif
