/***************************************************************************
                          alarmdlgimpl.cpp  -  description
                             -------------------
	begin                 :  Sat Oct 13 2001
	copyright           : (C) 2001-2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "alarmdlgimpl.h"
#include "birthdayitem.h"

#include <klocale.h>
#include <kprocess.h>

#include <qtabwidget.h>

AlarmDlgImpl::AlarmDlgImpl( QWidget* parent, const char* name, WFlags fl )
	:AlarmDlg( parent, name, fl )
{
	m_options = NULL;
	connect( lvBirthday, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT( slotClicked(QListViewItem*)) );
	connect( lvAnniversary, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT( slotClicked(QListViewItem*)) );
}

AlarmDlgImpl::~AlarmDlgImpl()
{
}

void AlarmDlgImpl::arrangeColumns()
{
	int width, visibleWidth;
	if( TabWidget->currentPage() == tabBirthday )
		visibleWidth = lvBirthday->visibleWidth();
	else
		visibleWidth = lvAnniversary->visibleWidth();
	width = visibleWidth
						- lvBirthday->columnWidth( 0 )
						- lvBirthday->columnWidth( 2 )
						- lvBirthday->columnWidth( 3 );
	lvBirthday->setColumnWidth( 1, width );
	width = visibleWidth
						- lvAnniversary->columnWidth( 0 )
						- lvAnniversary->columnWidth( 2 )
						- lvAnniversary->columnWidth( 3 );
	lvAnniversary->setColumnWidth( 1, width );
}

void AlarmDlgImpl::resizeEvent( QResizeEvent * )
{
	arrangeColumns();
}

void AlarmDlgImpl::showEvent( QShowEvent * )
{
	arrangeColumns();
}

bool AlarmDlgImpl::init( BirthdayOptions *options )
{
	if( ! options ) return false;
	m_options = options;

	// set scanning interval
	m_scanner.setScanOptions( m_options );

	// scan birthday from addressbook
	if( ! m_scanner.scan() ) return false;

	fillBirthday();
	fillAnniversary();

	if( TabWidget->count() == 0 ) return false;

	TabWidget->setCurrentPage( 0 );
	arrangeColumns();

	return true;
}

void AlarmDlgImpl::fillBirthday()
{
	uint i;
	BirthdayItem *row = NULL;
	BirthdayEventData event;

	lvBirthday->clear();

	// check for birthday events
	if( m_scanner.getEventsCount( true ) == 0 )
	{
		// remove birthday tab if no birthday events were found
		TabWidget->removePage( tabBirthday );
	}
	else
	{
		// add birthday tab if not present
		if( TabWidget->indexOf( tabBirthday) == -1 )
			TabWidget->insertTab( tabBirthday, i18n("&Birthdays"), 0 );
	}

	// scan all birthday events and insert into listview
	for( i = 0; i < m_scanner.getEventsCount( true ); i++ )
	{
		if( ! m_scanner.getEvent( i, event, true) ) break;
		// add birthday event to list
		row = new BirthdayItem( lvBirthday, event );

		lvBirthday->insertItem(  row  );
	}
}

void AlarmDlgImpl::fillAnniversary()
{
	uint i;
	BirthdayItem *row = NULL;
	BirthdayEventData event;

	lvAnniversary->clear();

	// check for anniversary events
	if( m_scanner.getEventsCount( false ) == 0 || ! m_options->ShowAnniversary() )
	{
		// remove anniversary tab if no anniversary events were found
		TabWidget->removePage( tabAnniversary );
	}
	else
	{
		// add anniversary  tab if not present
		if( TabWidget->indexOf( tabAnniversary ) == -1 )
			TabWidget->insertTab( tabAnniversary, i18n("&Anniversaries"), 1 );
	}

	// scan all anniversary events and insert into listview
	for( i = 0; i < m_scanner.getEventsCount( false ); i++ )
	{
		if( ! m_scanner.getEvent( i, event, false) ) break;
		// add anniversary event to list
		row = new BirthdayItem( lvAnniversary, event );
		lvAnniversary->insertItem(  row  );
	}
}

void AlarmDlgImpl::slotClicked(QListViewItem* item)
{
	BirthdayItem *bdItem = (BirthdayItem*) item;
	
	KProcess proc;
	proc << "kaddressbook";
	proc << "--editor-only";
	proc << "--uid";
	proc << bdItem->getUid();
	
	if( proc.start() )
	{
		proc.detach();
	}
}
