/***************************************************************************
                          birthdayeventdata.cpp  -  description
                             -------------------
    begin                : Tue Aug 6 2002
    copyright           : (C) 2002,2003 by Jan Hambrecht
    email                : jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "birthdayeventdata.h"

BirthdayEventData::BirthdayEventData()
{
	m_date = QDate().currentDate();
	m_name = "";
	m_days = 0;
	m_years = 0;
	m_color = QColor( 0, 0, 0 );
	m_uid = "";
}

BirthdayEventData::~BirthdayEventData()
{
}

void BirthdayEventData::setDate( const QDate &date )
{
	if( ! date.isValid() ) return;

	m_date = date;
}

QDate BirthdayEventData::getDate()
{                       
	return m_date;
}

void BirthdayEventData::setName( const QString &name )
{                        
	if( name.isEmpty() ) return;
	
	m_name = name;
}

QString BirthdayEventData::getName()
{                          
	return m_name;
}

int &BirthdayEventData::days()
{
	return m_days;
}

int &BirthdayEventData::years()
{
	return m_years;
}

QColor &BirthdayEventData::color()
{
	return m_color;
}

void BirthdayEventData::setUid( const QString &uid )
{
	if( uid.isEmpty() ) return;
	
	m_uid = uid;
}

QString BirthdayEventData::getUid()
{
	return m_uid;
}
