/***************************************************************************
                          confdlgimpl.h  -  description
                             -------------------
    begin                : Fri Oct 12 2001
    copyright           : (C) 2001-2003 by Jan Hambrecht
    email                :  jaham@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFDLGIMPL_H
#define CONFDLGIMPL_H

#include "birthdayoptions.h"
#include <confdlg.h>

/**
* @brief The implementation of the configuration dialog base class.
*@author Jan Hambrecht
*/
class ConfDlgImpl : public ConfDlg  
{
public: 
    /** @brief The constructor. */
	ConfDlgImpl( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
	
	/** @brief The destructor. */
    ~ConfDlgImpl();
	
  /** 
  * @brief Initializes the controls with the given birthday options. 
  * @param options The option object, containing the options to display.
  */
  void setOptions( BirthdayOptions &options );
  
  /** 
  * @brief Reads the new birthday options from the controls.
  * @param options The option object, receiving the read option values. 
  */
  void getOptions( BirthdayOptions &options );
};

#endif
