/* file events.h */
/*
 * kf linux jabber client
 * ----------------------
 *
 * Copyright (C) 2003-2004 Przemysaw Sitek <psitek@rams.pl> 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


typedef enum {
	KF_EVENT_CLASS_MESSAGE,
	KF_EVENT_CLASS_CHAT,
	KF_EVENT_CLASS_PRESENCE,
	KF_EVENT_CLASS_SUBSCRIPTION,
	KF_EVENT_CLASS_OFFLINE
} KfEventClass;

void kf_event (KfEventClass klass, gpointer user_data); 

void kf_event_queue (KfEventClass klass, const gchar *jid, gpointer data, GDestroyNotify notify);
void kf_event_release (const gchar *jid);
void kf_event_release_all (void);
gboolean kf_event_get (const gchar *jid);
gboolean kf_event_get_all (void);
