/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "qhacc.h"
#include "qhaccutils.h"
#include "qhaccwidget.h"

#include <stdlib.h>

#include <kglobal.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kapplication.h>
#include <kstandarddirs.h>

static const char * description=I18N_NOOP( "A Personal Finance Manager" );
static KCmdLineOptions options[] ={
	{ "debug <level>", I18N_NOOP( "set debugging output" ), 0 },
	{ "showhome", I18N_NOOP( "display the current KHACC_HOME setting" ), 0 },
	{ 0, 0, 0 }
};

int main( int argc, char **argv ){
	//if( argc<3 ) return EXIT_FAILURE; // don't continue without a home and root

	char * qroot=getenv( "QHACC_ROOT" );
	if( !qroot ){
		cerr<<"QHACC_ROOT environment variable not set."<<endl;
		return EXIT_FAILURE;
	}
	char * qhome=getenv( "KHACC_HOME" );

	KAboutData aboutData( "khacc", I18N_NOOP( "KHacc" ),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2004, ryan bobko", 0, 0,
		"ryan@ostrich-emulators.com" );
	aboutData.addAuthor( "ryan bobko", 0, "ryan@ostrich-emulators.com" );
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	//KApplication a( nargc, nargv );
	KApplication a;
	
	KCmdLineArgs * args=KCmdLineArgs::parsedArgs();
	QHacc qhacc( qroot );
	QString homer( qhome );
	if( homer=="DEFAULT" ){
		homer=KGlobal::dirs()->saveLocation( "appdata", QString::null, true );
	}

	if( args->isSet( "showhome" ) ){
		cout<<homer<<endl;
		return EXIT_SUCCESS;
	}

	QCString buggy=args->getOption( "debug" );
	Utils::setDebug( buggy.toInt() );

	if( !qhacc.setHome( homer ) ) return EXIT_FAILURE;

	args->clear(); // this just frees up a little space

	QHaccWidget * q=new QHaccWidget( &qhacc );
  if( a.isRestored() ){
		if( q->canBeRestored( 1 ) ) q->restore( 1 );
	}
	else{
		//QHaccWidget * q=new QHaccWidget( &qhacc );
		q->show();
	}
	//a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
	return a.exec();
}
