/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCTBOX_H
#define _QHACCACCTBOX_H

#include "qhacctablerows.h"

#include <qtoolbox.h>

class QHacc;
class QHaccAccountChooser;
class QHaccAccountBoxChooser;

class QAction;
class QPopupMenu;
class QMouseEvent;

class QHaccAccountBox : public QToolBox {
  Q_OBJECT
    public:
  QHaccAccountBox( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccAccountBox();

	TableRow getSelected() const;
	TableRow getMoused() const;

	void readPrefs( bool initial );
	void save() const;
	
	protected :
		QHacc * engine;
	QHaccAccountChooser * chooser;
	QPopupMenu * popup;
	QAction * rem;
	QHaccAccountBoxChooser * addTabAt( int idx, const QString& text );
	bool nosaves;

	void mousePressEvent( QMouseEvent * );
	void dragEnterEvent( QDragEnterEvent * );
	void dropEvent( QDropEvent * );

	protected slots:
		void changed( const Account& );
	void report( const Account& );
	void chart( const Account& );
	void recwin( const Account& );
	void subwin( const Account& );

	void newTabAbove();
	void newTabBelow();
	void removeTab();
	void renameTab();
	void tabChanged( int );
	void ssave();

 signals:
  void changedAccount( const Account& );
	void needRecWinOf( const Account& );
	void needSubsetOf( const Account& );
	void needReportOf( const Account& );
	void needGraphOf( const Account& );
};

#endif


