/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCTCHOOSER_H
#define _QHACCACCTCHOOSER_H

#include "qhacclistview.h"


class QHaccAViewItem : public QHaccListViewItem {
 public:
	QHaccAViewItem( QHaccListView * );
	QHaccAViewItem( QHaccListViewItem * );
	~QHaccAViewItem();

	int compare( QListViewItem * i, int col, bool ) const;
	bool acceptDrop( QMimeSource * );
	void dropper( QDropEvent * e );

	void paintCell( QPainter * p, const QColorGroup& cg, int c, int w, int aln );
	void paintBranches( QPainter *, const QColorGroup&, int, int, int );

	static void resetE( QHacc * engine );
	void setCurr( bool );
	
 protected:
	bool curr;
	static QColor maincolor, altcolor;
	static bool showanums;

	virtual void iinit();
};





class QHaccAccountChooser : public QHaccListView {
  Q_OBJECT
    public:
  QHaccAccountChooser( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccAccountChooser();

 protected:
	QColor color;
	QHaccAViewItem * lasti;

	void paintEmptyArea( QPainter * p, const QRect& rect );

	virtual void keyPressEvent( QKeyEvent * );
	void contentsDragEnterEvent( QDragEnterEvent * e );
	void contentsDropEvent( QDropEvent * e );
	void startDrag();

	void grabData();

	void isave() const;
	void ireadPrefs( bool );

	public slots:
		void setAccount( const Account& );

	protected slots:
	void changeP( const QString&, QColor );
	void changeP( const QString& p, bool );
	void changeP( const QString& p, float );
	void changeP( const QString& p, QString );

	void editAcct( QListViewItem *, const QPoint &, int );
	void renamer( QListViewItem *, int, const QString& );
	void updA( const Account&, const Account& );
	void selchange( QListViewItem * );
	void viewSubset();
	void toggleView();
	void recoAcct();
	void editAcct();
	void newAcct();
	void remAcct();
	void report();
	void chart();


 signals:
  void changedAccount( const Account& );
	void needRecWinOf( const Account& );
	void needSubsetOf( const Account& );
	void needReportOf( const Account& );
	void needGraphOf( const Account& );
};

#endif


