/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCLISTVIEW_H
#define _QHACCLISTVIEW_H

#include "qhacctablerows.h"

#include <map>
#include <memory>
using namespace std;

#include <qlistview.h>

class QHacc;
class QHaccTable;
class QHaccListView;
class QHaccTableIndex;

class QPainter;
class QKeyEvent;
class QPopupMenu;
class QMouseEvent;

class QHaccListViewItem : public QListViewItem {
 public:
	QHaccListViewItem( QHaccListView * );
	QHaccListViewItem( QHaccListViewItem * );
	virtual ~QHaccListViewItem();
	
	const TableRow& row() const;
	void setRow( const TableRow& );
	uint myid() const;

	static void resetE( QHacc * engine );
	
 protected:
	virtual void iinit();
	virtual void isetRow();
	int idcol;

	TableRow myrow;

	static QHacc * engine;
};


class QHaccListView : public QListView {
	Q_OBJECT
		public:
	QHaccListView( QHacc *, QWidget * =0, const char * =0 );
	virtual ~QHaccListView();

	const TableRow& getMoused() const;
	TableRow getSelected() const;

	void save() const;
	void readPrefs( bool );

	virtual void grabData();
	void setPrefBase( const QString& );
	void registerItem( uint, QHaccListViewItem * );
	void unregisterItem( uint );

 protected:
	QHacc * engine;
	auto_ptr<QPopupMenu> popup;
	TableRow contextTarget;
	QString prefbase;
	map<uint, QHaccListViewItem *>items;
	bool nosaves;
#if QT_VERSION<320
	int sortcol;
	bool sortasc;

	void setSorting( int, bool );
#endif

	TableRow getRow( QListViewItem * ) const;
	QHaccListViewItem * findRowItem( uint );

	void setPopup( QPopupMenu * );

	virtual void isave() const;
	virtual void ireadPrefs( bool );

	protected slots:
	void mouser( QListViewItem * );
	void makeData();
	void popper( QListViewItem *, const QPoint&, int );
	void ssave();
};

#endif
