/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhaccprefdlg.h"
#include "qhacc.h"
#include "config.h"
#include "qhaccutils.h"
#include "qhacctable.h"
#include "splitdialog.h"
#include "qhaccacctdlg.h"
#include "guiconstants.h"
#include "qhaccconstants.h"
#include "qhacclineedits.h"
#include "qhaccprefdlg.moc"

#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qfontdialog.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qcolordialog.h> 

#include <map>
#include <memory>

using namespace std;

#include <klocale.h>

/* * * * * * * * * * * * * * * * */
/* * * * * PREFS DIALOG  * * * * */
/* * * * * * * * * * * * * * * * */

PrefsDlg::PrefsDlg( QHacc * eng, int tab, QWidget * w, const char * n )
	: QTabDialog( w, n, false, WDestructiveClose ){
	
	engine=eng;

	tab1=new QHaccPrefsWidget( eng, this );
  addTab( tab1, i18n( "General" ) );

	QScrollView * scroller=new QScrollView( this );

	QHBoxLayout * hlay=new QHBoxLayout( scroller->viewport() );
  tab2=new QHaccGraphPrefsWidget( eng, scroller->viewport() );
  hlay->addWidget( tab2 );
  addTab( scroller, i18n( "Graphing and Reporting" ) );

	tab3=new QHaccOtherPrefsWidget( eng, this );
  addTab( tab3, i18n( "Defaults/Miscellaneous" ) );

	scroller=new QScrollView( this );
	QHBoxLayout * hlay2=new QHBoxLayout( scroller->viewport() );
	vector<int> t4p;
	t4p.push_back( QHacc::PIDATABASE );
	t4p.push_back( QHacc::PIIMPORTER );
	t4p.push_back( QHacc::PIEXPORTER );
	tab4=new QHaccPluginPrefsWidget( eng, t4p, scroller->viewport() );
	
  hlay2->addWidget( tab4 );
	addTab( scroller, i18n( "Plugin-Specific" ) );


	if( tab==1 ) showPage( tab2 );
	else if( tab==2 ) showPage( tab3 );
	else if( tab==3 ) showPage( tab4 );

  setCancelButton( i18n( "Dismiss" ) );
	setOKButton( i18n( "Accept" ) );

	setCaption( i18n( "KHacc Preferences" ) );
}

PrefsDlg::~PrefsDlg(){}

void PrefsDlg::accept(){
	tab1->accept();
	tab2->accept();
	tab3->accept();
	tab4->accept();
	QTabDialog::accept();
}


QHaccOtherPrefsWidget::QHaccOtherPrefsWidget( QHacc * eng, QWidget * w,
																							const char * n )
  : QWidget( w, n ){

	engine=eng;

  QGridLayout * layout=new QGridLayout( this, 21, 11, 5 );

	int row=1;
	autosave=new QCheckBox( this );
	autosave->setChecked( engine->getBP( "AUTOSAVE" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Auto Save" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( autosave, row, row, 5, 9 );
	row++;

	simpleFD=new QCheckBox( this );
	simpleFD->setChecked( engine->getBP( "SIMPLEFILEDIALOG" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Use Simple KHACC_HOME Dialog" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( simpleFD, row, row, 5, 9 );
	row++;

	maintbal=new QCheckBox( this );
	maintbal->setChecked( engine->getBP( "IMPORTSKEEPCURRBAL" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Preserve Account Balances During Import" ), this ), row, row, 1, 4 );
	layout->addMultiCellWidget( maintbal, row, row, 5, 9 );
	row++;

	defAcct=new QPushButton( i18n( "Configure Default Account" ), this );
  connect( defAcct, SIGNAL( clicked() ), SLOT( modAcct() ) );
	layout->addMultiCellWidget( defAcct, row, row, 1, 9 );
	row++;

	rollup=new QCheckBox( this );
	rollup->setChecked( engine->getBP( "INCLUDESUBSONRECALC" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "\"Roll-up\" Sub-account Sums" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( rollup, row, row, 5, 9 );
	row++;

	altcurrency=new QCheckBox( this );
	altcurrency->setChecked( engine->getBP( "USEALTCURRENCY" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Use Alternate Currency" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( altcurrency, row, row, 5, 9 );
	row++;
	
	altfactor=new QLineEdit( engine->getSP( "ALTCURRENCYFACTOR" ), this );
	layout->addMultiCellWidget( new QLabel( i18n( "Alternate Exchange Rate" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( altfactor, row, row, 5, 9 );
	row++;

	altsymbol=new QLineEdit( engine->getSP( "ALTCSYMBOL" ), this );
	layout->addMultiCellWidget( new QLabel( i18n( "Alternate Currency Symbol" ),
																					this ), row, row, 1, 4 );
	layout->addMultiCellWidget( altsymbol, row, row, 5, 9 );
	//row++;
}


QHaccOtherPrefsWidget::~QHaccOtherPrefsWidget(){}
void QHaccOtherPrefsWidget::accept(){
	const char * pref[]={ "SIMPLEFILEDIALOG", "IMPORTSKEEPCURRBAL", "AUTOSAVE",
												"USEALTCURRENCY", "INCLUDESUBSONRECALC" };
	QCheckBox * widg[]={ simpleFD, maintbal, autosave, altcurrency, rollup };
	for( int i=0; i<5; i++ ) engine->setBP( pref[i], widg[i]->isChecked() ); 
	engine->setFP( "ALTCURRENCYFACTOR", altfactor->text().toFloat() );
	engine->setSP( "ALTCSYMBOL", altsymbol->text() );	
}

void QHaccOtherPrefsWidget::modAcct(){
	( new AccountDlg( engine, engine->getBlankA(), this ) )->show();
}

QHaccGraphPrefsWidget::QHaccGraphPrefsWidget( QHacc * eng, QWidget * w,
																							const char * n )
  : QWidget( w, n ){

	engine=eng;

  QGridLayout * layout=new QGridLayout( this, 21, 11, 5 );

  grapher=new QButtonGroup( 3, Horizontal, i18n( "Default Graph" ), this );
  reporter=new QButtonGroup( 3, Horizontal, i18n( "Default Report" ), this );

	int pitype[]={ QHacc::PIGRAPHER, QHacc::PIREPORTER };
	QButtonGroup * bgs[]={ grapher, reporter };
	QString pipref[]={ "GRAPHTYPE", "REPORTTYPE" };

	for( int i=0; i<2; i++ ){
    vector<PluginInfo> info( engine->getPluginInfo( pitype[i] ) );
    for( vector<PluginInfo>::iterator it=info.begin(); it!=info.end(); it++ ){
      new QRadioButton( it->descr(), bgs[i] );
    }
		
		bgs[i]->setButton( engine->getIP( pipref[i] ) );
	}

	grtime=new QLineEdit( QString().setNum( engine->getIP( "GRAPHTIME" ) ),
												this );
	QIntValidator * v=new QIntValidator( grtime );
	v->setBottom( 1 );
	grtime->setValidator( v );
	grtime->setAlignment( AlignCenter );

	int row=1;
  layout->addMultiCellWidget( grapher, row, row, 1, 9 );
  row+=2;

  layout->addMultiCellWidget( reporter, row, row, 1, 9 );
  row+=2;

	layout->addMultiCellWidget( new QLabel( i18n( "Months to Display" ), this ),
															row, row, 1, 4 );
	layout->addMultiCellWidget( grtime, row, row, 5, 6 );
	row++;

	vector<int>tpp;
	tpp.push_back( QHacc::PIGRAPHER );
	tpp.push_back( QHacc::PIREPORTER );
	plugins=new QHaccPluginPrefsWidget( engine, tpp, this );

	layout->addMultiCellWidget( plugins, row, row+10, 1, 9 );
}

QHaccGraphPrefsWidget::~QHaccGraphPrefsWidget(){}
void QHaccGraphPrefsWidget::accept(){
	const int PS=3;
	const char * ps[]={ "GRAPHTYPE", "REPORTTYPE", "GRAPHTIME" };
	int ints[]={ grapher->id( grapher->selected() ),
							 reporter->id( reporter->selected() ),
							 grtime->text().toInt() };
	for( int i=0; i<PS; i++ ) engine->setIP( ps[i], ints[i] );

	plugins->accept();
}


QHaccPrefsWidget::QHaccPrefsWidget( QHacc * eng, QWidget * w,	const char * n )
  : QWidget( w, n ){
	engine=eng;

  QGridLayout * layout=new QGridLayout( this, 21, 11, 5 );

	/*
  mbtn=new QPushButton( i18n( "Main Color" ), this );
  mbtn->setPalette( engine->getCP( "MAINCOLOR" ) );
  connect( mbtn, SIGNAL( clicked() ), SLOT( mColor() ) );
  
  abtn=new QPushButton( i18n( "Alt Color" ), this );
  abtn->setPalette( engine->getCP( "ALTCOLOR" ) );
  connect( abtn, SIGNAL( clicked() ), SLOT( aColor( ) ) );
	*/
  title=new QLineEdit( engine->getSP( "TITLEBARNAME" ), this );

  cats=new QCheckBox( this );
  cats->setChecked( engine->getBP( "HIDECATEGORIES" ) );

  hideleds=new QCheckBox( this );
  hideleds->setChecked( engine->getBP( "HIDEJOURNALS" ) );

  showrec=new QCheckBox( this );
  showrec->setChecked( engine->getBP( "SHOWRECBAL" ) );

  showanums=new QCheckBox( this );
  showanums->setChecked( engine->getBP( "CHOOSERSHOWANUMS" ) );

	/*
  fbtn=new QPushButton( i18n( "Change this Font" ), this );
  connect( fbtn, SIGNAL( clicked() ), SLOT( cFont( ) ) );

  symbol=new QLineEdit( engine->getSP( "CSYMBOL" ), this );
  symbol->setAlignment( AlignCenter );
	*/
  sep=new QLineEdit( engine->getSP( "DATESEPARATOR" ), this );
  sep->setAlignment( AlignCenter );
  sep->setMaxLength( 1 );
	/*
  currseper=new QLineEdit( engine->getSP( "CURRENCYSEPARATOR" ), this );
  currseper->setAlignment( AlignCenter );
  currseper->setMaxLength( 1 );
	*/
  
	liner=new QButtonGroup( 2, Horizontal, i18n( "Bookkeeping Method" ), this );
  new QRadioButton( i18n( "Single Entry" ), liner );
  new QRadioButton( i18n( "Double Entry" ), liner );
  liner->setButton( engine->getBP( "DOUBLEENTRY" ) ? 1 : 0 );

  dater=new QButtonGroup( 2, Horizontal, i18n( "Date Format" ), this );
  new QRadioButton( i18n( "American (MM/DD/YYYY)" ), dater );
  new QRadioButton( i18n( "European (DD/MM/YYYY)" ), dater );
  new QRadioButton( i18n( "Year First (YYYY/MM/DD)" ), dater );
	dater->setButton( engine->getIP( "DATEFORMAT" ) );
	
  int row=0;
	/*
  layout->addMultiCellWidget( mbtn, row, row+1, 1, 4 );
  layout->addMultiCellWidget( abtn, row, row+1, 6, 9 );

  row+=2;
	*/
  layout->addMultiCellWidget( liner, row, row+2, 1, 9 );
  row+=3;
  layout->addMultiCellWidget( dater, row, row+2, 1, 9 );
  row+=3;

  QWidget * wa[]={ cats, showanums, hideleds, showrec, sep, symbol, currseper};
	const char * ns[]={ I18N_NOOP( "Hide Categories in Chooser" ),
											I18N_NOOP( "Show Account Numbers in Chooser" ),
											I18N_NOOP( "Hide Journals" ),
											I18N_NOOP( "Show Reconciled Balance in Status" ),
											I18N_NOOP( "Date Separator" ),
											I18N_NOOP( "Currency Symbol" ),
											I18N_NOOP( "Currency Separator" ) };	
  
  //for ( int i=0; i<7; i++ ){
	for ( int i=0; i<5; i++ ){
    layout->addMultiCellWidget( new QLabel( i18n( ns[i] ), this ),
																row, row, 1, 5 );
    layout->addMultiCellWidget( wa[i], row, row, 6, 7 );
    row++;
  }

  //layout->addMultiCellWidget( fbtn, row, row, 1, 9 );
  //row+=2;

  autocomps=new QComboBox( false, this );
  autocomps->insertItem( i18n( "No Transactions" ) );
  autocomps->insertItem( i18n( "New Transactions Only" ) );
  autocomps->insertItem( i18n( "All Transactions" ) );
  autocomps->setCurrentItem( engine->getIP( "AUTOCOMPLETION" ) );

	const char * wsn[]={ I18N_NOOP( "Dataset Name" ), 
											 I18N_NOOP( "Auto-Complete on " ) };
	QWidget * ws[]={ title, autocomps };
  for ( int i=0; i<2; i++ ){
    layout->addMultiCellWidget( new QLabel( i18n( wsn[i] ), this ),
																row, row, 1, 5 );
    layout->addMultiCellWidget( ws[i], row, row, 6, 9 );
    row++;
  }

	igcase=new QCheckBox( this );
  igcase->setChecked( engine->getBP( "AUTOCOMPNOCASE" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Auto-Complete Ignores Case" ),
																					this ),	row, row, 1, 5 );
	layout->addMultiCellWidget( igcase, row, row, 6, 9 );

	row++;
	gtypeahead=new QCheckBox( this );
  gtypeahead->setChecked( engine->getBP( "GLOBALTYPEAHEAD" ) );
	layout->addMultiCellWidget( new QLabel( i18n( "Global Auto-Complete" ),
																					this ),	row, row, 1, 5 );
	layout->addMultiCellWidget( gtypeahead, row, row, 6, 9 );
}

QHaccPrefsWidget::~QHaccPrefsWidget(){}

void QHaccPrefsWidget::accept(){
	const char * sps[]={ "TITLEBARNAME", "CSYMBOL", "DATESEPARATOR", 
											 "CURRENCYSEPARATOR" };
	QLineEdit * spps[]={ title, symbol, sep, currseper };
	for( int i=0; i<1; i++ ) engine->setSP( sps[i], spps[i]->text() );
	QHaccDateEdit::setDateSeparator( sep->text() );

  //engine->setCP( "MAINCOLOR", mbtn->backgroundColor() );
  //engine->setCP( "ALTCOLOR", abtn->backgroundColor() );

  //engine->setWP( "FONT", fonter );

	engine->setBP( "DOUBLEENTRY", liner->id( liner->selected() )==1 );
	const char * sps2[]={ "HIDECATEGORIES", "HIDEJOURNALS", "AUTOCOMPNOCASE",
												"SHOWRECBAL",	"GLOBALTYPEAHEAD", "CHOOSERSHOWANUMS" };
	QCheckBox * spps2[]={ cats, hideleds, igcase, showrec,
												gtypeahead, showanums };
	for( int i=0; i<6; i++ ) engine->setBP( sps2[i], spps2[i]->isChecked() );


	int dfi=dater->id( dater->selected() );
	engine->setIP( "DATEFORMAT", dfi );
	QHaccDateEdit::setDateFormat( ( QHaccDateEdit::DateFormat )dfi );
	engine->setIP( "AUTOCOMPLETION", autocomps->currentItem() );

}

void QHaccPrefsWidget::mColor(){
  QColor c=QColorDialog::getColor( mbtn->backgroundColor() );
  if ( c.isValid() ) mbtn->setPaletteBackgroundColor( c );
}
void QHaccPrefsWidget::aColor(){
  QColor c=QColorDialog::getColor( abtn->backgroundColor() );
  if ( c.isValid() ) abtn->setPaletteBackgroundColor( c );
}
void QHaccPrefsWidget::cFont(){
  bool ok;
  QFont f=QFontDialog::getFont( &ok, font(), 0 );
  if ( ok ){
    setFont( f );
    fonter=f;
  }
}

QHaccPluginPrefsWidget::QHaccPluginPrefsWidget( QHacc * eng, vector<int> types,
																								QWidget * w, const char * n )
  : QWidget( w, n ){
	
	engine=eng;
	pimap=new QHaccResultSet( QC::IPICOLS, QC::IPICOLTYPES );
	
	const QString SEP=":";

	map<QString, TableRow> pitmap;

	for( uint i=0; i<types.size(); i++ ){
    vector<PluginInfo> info( engine->getPluginInfo( types[i] ) );
    for( vector<PluginInfo>::iterator it=info.begin(); it!=info.end(); it++ ){
      auto_ptr<QHaccResultSet> prefs( it->prefs() );
      uint rr=prefs->rows();
      for( uint j=0; j<rr; j++ ) {
        TableRow row=prefs->at( j );
        const QString pref=row[QC::IPIPREF].gets();

        map<QString, TableRow>::iterator iter=pitmap.find( pref );
        if( iter==pitmap.end() ){
          // no tablerow in our map yet, so add one
          row.set( QC::IPIDESCR, it->descr() );
          pitmap[pref]=row;
        }
        else{
          // we already have a row in our map, so update the
          // IPI (plugin stub) to include this plugin stub
          TableRow row=iter->second;
          row.set( QC::IPIDESCR, row[QC::IPIDESCR].gets()+SEP+it->descr() );
          iter->second=row;
        }
      }
    }
	}

	// convert from the map to the resultset
	QGridLayout * lay=new QGridLayout( this, 20, 11, 5 );
	map<QString, TableRow>::iterator iter=pitmap.begin();
	for( ; iter!=pitmap.end(); iter++ ){
		TableRow row=iter->second;
		
		// get rid of duplicates from the plugins that use this preference
		QStringList lister=QStringList::split( SEP, row[QC::IPIDESCR].gets() );
		lister.sort();
		QString str, laststr="";
		for ( QStringList::Iterator it=lister.begin(); it!=lister.end(); ++it ) {
			if( *it!=laststr ){
				laststr=*it;
				if( str.isNull() ) str=laststr;
				else str+=", "+laststr;
			}
		}
		row.set( QC::IPIDESCR, str );
		
		pimap->add( row );
	}


	// now cycle through the resultset and put the widgets on the screen
	uint rr=pimap->rows();
	widgets=new QWidget * [rr];
	for( uint i=0; i<rr; i++ ){
		const TableRow row=pimap->at( i );
		const QString PREF=row[QC::IPIPREF].gets();

		// probably need to expand this a bit, huh?
		const int PI=row[QC::IPITYPE].geti();
		switch( PI ){
		case CTBOOL:
			widgets[i]=new QCheckBox( this );
			( ( QCheckBox * )widgets[i] )->setChecked( engine->getBP( PREF ) );
			break;
		default:
			widgets[i]=new QLineEdit( engine->getSP( PREF ), this );
		}

		if( PI==CTINT || PI==CTUINT || PI==CTFLOAT )
			( ( QLineEdit * )widgets[i] )->setAlignment( AlignCenter );
		
		lay->addMultiCellWidget( new QLabel( row[QC::IPILABEL].gets(), this ),
														 i, i, 1, 1 );
		lay->addMultiCellWidget( widgets[i], i, i, 2, 2 );
		//lay->addMultiCellWidget( new QLabel( i18n( "used by %1" ).arg( row[QC::IPIDESCR].gets() ), this ), i, i, 3, 9 );
	}
}

QHaccPluginPrefsWidget::~QHaccPluginPrefsWidget(){ delete pimap; }
void QHaccPluginPrefsWidget::accept(){
	uint rr=pimap->rows();
	for( uint i=0; i<rr; i++ ){
		const TableRow row=pimap->at( i );
		const QString PREF=row[QC::IPIPREF].gets();

		const int PI=row[QC::IPITYPE].geti();
		switch( PI ){
		case CTBOOL:
			engine->setBP( PREF, ( ( QCheckBox * )widgets[i] )->isChecked() );
			break;
		default:
			engine->setSP( PREF, ( ( QLineEdit * )widgets[i] )->text() );
		}
	}
}
