/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/
 
#ifndef _QHACCRECWIZ_H
#define _QHACCRECWIZ_H

#include "qhacctablerows.h"

#include <qwidget.h>
#include <qdatetime.h>

class QHacc;
class QLabel;
class QLineEdit;
class QHaccView;
class QHaccRecView;
class QHaccLineEdit;
class QHaccDateEdit;

class QHaccRecWin : public QWidget {
  Q_OBJECT
 public:
  QHaccRecWin( QHacc *, const Journal&, QWidget * =0, const char * =0 );
  ~QHaccRecWin();
	
	void readPrefs( bool );
	void save();
	
	void setAccount( const Account& );
	QHaccView * getView() const;

 private:
	QHacc * engine;
  QHaccRecView * tView;
  QHaccDateEdit * enddate;
  QHaccLineEdit * ebal;
	QLabel * lblDiff, * lblOBal;
  Account account;
	Journal journal;

  protected slots:
    void hide();
  void changeDate();
	void changeP( const QString&, int );
	void changeP( const QString&, QString );
  void accept();
  void cancel();
	void refresh();
	void removeA( const Account& );
	void modT( const Transaction& );
};

#endif
