/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/
 
#ifndef _QHACCSUBSETWIN_H
#define _QHACCSUBSETWIN_H

#include "qhacctablerows.h"

#include <qwidget.h>
#include <vector>
using namespace std;

class QHacc;
class QLabel;
class QComboBox;
class QHaccView;
class TableSelect;
class QHaccDateEdit;
class QHaccLineEdit;
class QHaccChoiceEdit;
class TableSelectDisplay;
class QHaccReportPlugin;

class QHaccSubsetWin : public QWidget {
  Q_OBJECT
 public:
  QHaccSubsetWin( QHacc *, QWidget * =0, const char * =0 );
  ~QHaccSubsetWin();
	
	void readPrefs( bool );
	void save();
	
	void setSelectors( vector<TableSelect> );
	//void setAll( uint journalid, const Account&, const QDate& start, 
	//					 const QDate& end );
	void setAL( const Account&, const Journal& );
	void setInfo( vector<TableSelect> );
	QHaccView * getView() const;

 private:
	QHacc * engine;
	uint journalid;
  QHaccView * view;
	Account account;
	QLabel ** info;
	TableSelectDisplay ** sels;
	uint infosize;
	QHaccReportPlugin * plugin;

	static const int NTRANS, LTRANS, STRANS, ATRANS, ADELTA, NUMDISPLAYS;

  protected slots:
		void changeAll();
	void removeA( const Account& );
	void changeP( const QString&, int );
	void changeP( const QString&, QString );
	void close();
};

class TableSelectDisplay : public QWidget {
	Q_OBJECT
		public:
	TableSelectDisplay( const TableSelect&, QWidget * =0, const char * =0 );
	~TableSelectDisplay();

	TableSelect get() const;
	void set( const TableSelect& );
	
 protected:
	QComboBox * sel, * col;
	QHaccLineEdit * val;

	protected slots:
		void upd();

 signals:
	void updated();
			
};
#endif

