/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

	// the alternating color code is mostly from klistview

#ifndef _QHACCVIEW_H
#define _QHACCVIEW_H

#include "qhacclistview.h"

#include <qdatetime.h>

#include <map>
#include <vector>
using namespace std;

class QHacc;
class QHaccTable;
class TableSelect;
class QHaccResultSet;
class TransactionEditor;

class QAccel;
class QColorGroup;

class QHaccTViewItem : public QHaccListViewItem {
 public:
	QHaccTViewItem( QHaccListView *, bool de );
	QHaccTViewItem( QHaccListViewItem *, bool de );
	virtual ~QHaccTViewItem();

	static void resetE( QHacc * );

	void setCheckNums( bool );
	void setDrawDoubleEntry( bool );
	void setDoubleEntry( bool b );
	void updateA( const Account & );

	int compare( QListViewItem * i, int col, bool ) const;
	bool acceptDrop( QMimeSource * );
	virtual void setup();
	void paintCell( QPainter * p, const QColorGroup& cg, int c, int w, int aln );
	void dropper( QDropEvent * );

 protected:
	static const QDate BASEDATE;
	uint pairacct;
	// are we split, in doubleentry mode, and have we resolved our pair account?
	bool issplit, doubleentry, resolved, drawdoubleentry;
	bool m_known, m_odd; // for alternating paint colors
	bool numonnum;
	QString pairstr; // pair account name, or GUIC::SPLIT
	static QHaccTable * acctcache;
	static QColor maincolor, altcolor;
	static bool nocase;
	int datecompval, sumcompval, numcompval;

	bool usealt(); // use alternate background color?
	void isetRow();
	void resolve();
	virtual void iinit();
};

class QHaccView : public QHaccListView {
  Q_OBJECT
    public:
  QHaccView( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccView();

	void setSelectors( vector<TableSelect> );
	QListViewItem * paintAbove, * paintCurrent, * paintBelow;
	bool painting;

 protected:
	QColor color;
	int editorLPT;
	Account account;
	Journal journal;
	vector<TableSelect> selectors;
	QAccel * accelerators;

	void contentsDragEnterEvent( QDragEnterEvent * e );
	void contentsDropEvent( QDropEvent * e );
	void startDrag();

	void keyPressEvent( QKeyEvent * );
	virtual void grabData();
	void paintEmptyArea( QPainter * p, const QRect& rect );
	void viewportPaintEvent( QPaintEvent * );
	virtual void ifinishItem( QHaccTViewItem * );

	virtual QDate getIUMDate() const;
	void dropEditor();

	bool iInclude( const Transaction& t ) const;
	//void imakeCopy();
	void ireadPrefs( bool );
	virtual void irecTrans( Transaction& );
	virtual void ifinishEditor( TransactionEditor * );
	void icopycut( bool cut );

 private:
	auto_ptr<QHaccTable> acctnames, memtrans;

	void openEditor( const QRect&, const Split&, 
									 const QDate =QDate::currentDate() );
	void grabMemData();

	TransactionEditor * editor;
	int highNum, paster;
	QPopupMenu * mempop;
	bool pushEditorRecButton;

	public slots:
		void setAccount( const Account& );
		void setJournal( const Journal& );
		void transCopied( bool );

	protected slots:
		void newTrans();
	void remTrans();
	void recTrans();
	
	private slots:
	void changeP( const QString&, bool );
	void changeP( const QString&, QColor );
	void changeP( const QString&, QString );
	void changeP( const QString&, float );
	void changeP( const QString&, int );

	void editTrans( QListViewItem * );
	
	void closeEditor();
	virtual void editTrans();

	void addT( const Transaction& );
	void updT( const Transaction& );
	void remT( const Transaction& );

	void memTrans();       // memorize a transaction
	void addMTrans( int ); // add a previously-memorized transaction
	void edMTrans();       // open memorized editor

	void cutTrans();
	void copyTrans();
	void pasteTrans();

	void addA( const Account& );
	void removeA( const Account& );
	void updateA( const Account&, const Account& );
	
 signals:
  void transToClipboard( bool );
};

class QHaccRecView : public QHaccView {
  Q_OBJECT
    public:
  QHaccRecView( QHacc *, QWidget * =0, const char * =0 );
  virtual ~QHaccRecView();
  auto_ptr<QHaccTable> getContents() const;
	
	void setLimit( const QDate& );
	
 protected:
	void doSetChosen( int );
	QDate getIUMDate() const;
	void irecTrans( Transaction& t );
	virtual void ifinishEditor( TransactionEditor * );
	virtual void ifinishItem( QHaccTViewItem * );

 private:
  QDate limit;
};

#endif
