/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _TRANSEDITOR_H
#define _TRANSEDITOR_H

#include "qhacctablerows.h"

#include <qframe.h>

#include <memory>
using namespace std;

class QHaccDateEdit;
class QHaccLineEdit;
class QHaccChoiceEdit;
class QHaccResultSet;
class QHaccTable;
class MonCon;
class QHacc;

class QResizeEvent;
class QPushButton;
class QCloseEvent;
class QCheckBox;
class QPainter;
class QHeader;

class TransactionEditor : public QFrame {
  Q_OBJECT
    public:
	friend class AccountArea;


  TransactionEditor( QHacc *, const Account&, const Journal&, bool, QWidget *,
										 const char * =0 );
  ~TransactionEditor();
	
	/**
	 * Prepare the editor for a new transaction
	 * @param t The transaction
	 * @param forEdit Are we adding a new one or editing and old one?
	 */
  void prepare( const Transaction& t, bool forEdit );

	/**
	 * Layout the widgets to take new dimensions into account
	 */
  void reLayout( QHeader *, const QRect& );

	/**
	 * Set the default reconcile mode when adding/editing the transaction
	 */
	void setRecMode( uint );
	
	/**
	 * Should the reconcile button be selected?
	 */
	void setRecButton( bool );

 protected:
  QHaccChoiceEdit * num, * payee, * credit, * debit, * deAccount;
  QHaccLineEdit * memo;
  QHaccDateEdit * date;
  QPushButton * split, * okay;
  QCheckBox * reco;
	QHacc * engine;
	auto_ptr<MonCon> conv;
  Transaction origT, model; // these are extended transactions
  Account account;
	Journal journal;
	bool doubleEntry, edit, named, connected, nocaselkp, globalTA, closing;
	uint recstate;
	int autocomp;
	auto_ptr<QHaccTable> atrans, tsplits;
	auto_ptr<QHaccTableIndex> apidx;

	void makePayees();
	void setModel( const Transaction&, bool conv =true );
	void keyPressEvent( QKeyEvent * );
	void accept();
	
  void closeEvent( QCloseEvent * );
	QString getPNameFor( uint tid, uint notAID );

  protected slots:
		void conditionallyAccept();
  void fillInForPayee( const QString& );
	void changeP( const QString&, bool );
	void changeP( const QString&, int );
	void popDEA();
  void moveInCredit( const QString& );
  void moveInDebit( const QString& );
  void openSplitEditor();

 signals:
  void closed();
};

#endif
