/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/
#ifndef _QHACCCOPYSTORE_H
#define _QHACCCOPYSTORE_H

#include "qhacctable.h"

#include <qdragobject.h>

/*
class QHaccTDrag : public QUriDrag {
 public:
	QHaccTDrag( const TableRow& t, const QHaccTable& s, uint a, 
								QWidget * parent = 0, const char * name = 0 );
	~QHaccTDrag();

	//static bool canDecode( QDragMoveEvent * e );
	static bool decode( QMimeSource * e, TableRow& t, QHaccTable& s, uint& a );
};

class QHaccADrag : public QTextDrag {
 public:
	QHaccADrag( const TableRow& t, QWidget * parent =0, const char * name =0 );
	~QHaccADrag();

	static bool decode( QMimeSource * e, TableRow& t );
};
*/

class QHaccTDrag : public QDragObject {
 public:
	QHaccTDrag( const TableRow& t, const QHaccTable& s, uint a, 
							QWidget * parent =0, const char * name =0 );
	~QHaccTDrag();

	static bool canDecode( QMimeSource * e );
	static bool decode( QMimeSource * e, TableRow& t, QHaccTable& s, uint& a );
	bool provides( const char * mimeType ) const;

 protected:
	TableRow trans;
	QHaccTable splits;
	uint accountid;

	const char * format( int ) const;
	QByteArray encodedData( const char * ) const;
};

class QHaccADrag : public QDragObject {
 public:
	QHaccADrag( const TableRow& t, QWidget * parent =0, const char * name =0 );
	~QHaccADrag();

	static bool canDecode( QMimeSource * e );
	static bool decode( QMimeSource * e, TableRow& a );
	bool provides( const char * mimeType ) const;

 protected:
	TableRow account;

	const char * format( int ) const;
	QByteArray encodedData( const char * ) const;
};

#endif
