/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "qhaccacctbox.h"
#include "qhacc.h"
#include "copystore.h"
#include "qhacctable.h"
#include "qhaccacctchsr.h"
#include "qhaccacctboxchsr.h"
#include "qhaccacctbox.moc"

#include <qevent.h>
#include <qaction.h>
#include <qpopupmenu.h>
#include <qinputdialog.h>

#include <klocale.h>

QHaccAccountBox::QHaccAccountBox( QHacc * eng, QWidget * p,	const char * c ) 
	: QToolBox( p, c ){

	nosaves=true;
	engine=eng;
	setAcceptDrops( true );

	chooser=new QHaccAccountChooser( eng, this, "chooser" );
	addItem( chooser, i18n( "All Accounts" ) );

	connect( this, SIGNAL( currentChanged( int ) ), SLOT( tabChanged( int ) ) );

	connect( chooser, SIGNAL( needRecWinOf( const Account& ) ),
					 this, SLOT( recwin( const Account& ) ) );
	connect( chooser, SIGNAL( needSubsetOf( const Account& ) ),
					 this, SLOT( subwin( const Account& ) ) );
	connect( chooser, SIGNAL( changedAccount( const Account& ) ),
					 this, SLOT( changed( const Account& ) ) );
	connect( chooser, SIGNAL( needReportOf( const Account& ) ),
					 this, SLOT( report( const Account& ) ) );
	connect( chooser, SIGNAL( needGraphOf( const Account& ) ),
					 this, SLOT( chart( const Account& ) ) );

	/*
	connect( boxer, SIGNAL( changedAccount( const Account& ) ),
					 chooser, SLOT( setAccount( const Account& ) ) );

	connect( boxer, SIGNAL( needRecWinOf( const Account& ) ),
					 this, SLOT( recwin( const Account& ) ) );
	connect( boxer, SIGNAL( needSubsetOf( const Account& ) ),
					 this, SLOT( subwin( const Account& ) ) );
	connect( boxer, SIGNAL( changedAccount( const Account& ) ),
					 this, SLOT( changed( const Account& ) ) );
	connect( boxer, SIGNAL( needReportOf( const Account& ) ),
					 this, SLOT( report( const Account& ) ) );
	connect( boxer, SIGNAL( needGraphOf( const Account& ) ),
					 this, SLOT( chart( const Account& ) ) );
	*/


	setFocusPolicy( StrongFocus );
	popup=new QPopupMenu();
	
	
	rem=new QAction( i18n( "remove current tab" ), QPixmap(),
									 i18n( "remove current tab" ), QKeySequence(), this );
	connect( rem, SIGNAL( activated() ), SLOT( removeTab() ) );

  popup->insertItem( i18n( "add tab above" ), this, SLOT( newTabAbove() ) );
  popup->insertItem( i18n( "add tab below" ), this, SLOT( newTabBelow() ) );
  popup->insertItem( i18n( "rename current tab" ), this, SLOT( renameTab() ) );
	rem->addTo( popup );

	// to start with, we only have one item, and it's the one we can't remove
	rem->setEnabled( false );
}

QHaccAccountBox::~QHaccAccountBox(){}

void QHaccAccountBox::readPrefs( bool b ){
	chooser->readPrefs( b ); 
	const Account cha=chooser->getSelected();

	if( !b ){
		nosaves=true;

		// we're opening a new home, so delete the current set of tabs
		for( int i=0; i<count(); i++ ){
			if( item( i )!=chooser ){ // but ignore the main chooser
				QWidget * it=item( i );
				if( removeItem( it )!=-1 ) delete it;
			}
		}
	}


	// add tabs now
	int ntabs=engine->getIP( "CHOOSERBOXTABS" );
	for( int i=0; i<ntabs; i++ ){
		const QString starter="CHOOSERBOXTAB"+QString::number( i );
		const QString str=engine->getSP( starter+"NAME" );
		const QString aids=engine->getSP( starter+"ACCTS" );
		if( aids=="*" ){
			// move the all accounts tab to the proper position and change
			// its name to the right name
			removeItem( chooser );
			insertItem( i, chooser, str );
		}
		else{
			// add boxchsr
			QHaccAccountBoxChooser * boxer=addTabAt( i, str );
			// add accounts to boxchsr
			QStringList lister=QStringList::split( " ", aids );
			uint * aidarr=new uint[lister.count()];
			int idx,cnt;
			idx=cnt=lister.count();
			
			// qstringlist seems to iterate backwards, so compensate for that
			for( QStringList::Iterator it=lister.begin(); it!=lister.end(); ++it )
				aidarr[--cnt]=( *it ).toUInt();
			for( int i=0; i<idx; i++ )boxer->addAccount( engine->getA( aidarr[i] ) );
			delete [] aidarr;

			// finally, set the selected account
			boxer->setAccount( cha );
		}
	}

	setCurrentItem( item( engine->getIP( "CHOOSERBOXINDEX" ) ) );

	nosaves=false;
}

void QHaccAccountBox::ssave(){ save(); }
void QHaccAccountBox::save() const{
	if( nosaves ) return;

	engine->setIP( "CHOOSERBOXINDEX", currentIndex() );
	chooser->save();

	uint cnt=count();
	engine->setIP( "CHOOSERBOXTABS", ( int )cnt );
	for( uint i=0; i<cnt; i++ ){
		QHaccListView * view=( QHaccListView * )item( i );
		const QString str="CHOOSERBOXTAB"+QString::number( i );
		engine->setSP( str+"NAME", itemLabel( i ) );
		if( view==chooser ) engine->setSP( str+"ACCTS", "*" );
		else{
			// cycle through accounts
			QString accts;
			QListViewItemIterator it( view );
			while( it.current() ){
				QHaccListViewItem * item=( QHaccListViewItem * )it.current();
				accts+=item->row()[QC::AID].gets()+" ";
				++it;
			}
			engine->setSP( str+"ACCTS", accts );
		}
	}
}

void QHaccAccountBox::changed( const Account& a ){ emit changedAccount( a ); }
void QHaccAccountBox::report( const Account& a ){ emit needReportOf( a ); }
void QHaccAccountBox::chart( const Account& a ){ emit needGraphOf( a ); }
void QHaccAccountBox::recwin( const Account& a ){ emit needRecWinOf( a ); }
void QHaccAccountBox::subwin( const Account& a ){ emit needSubsetOf( a ); }

TableRow QHaccAccountBox::getMoused() const { return chooser->getMoused(); }
TableRow QHaccAccountBox::getSelected() const {
	return chooser->getSelected(); 
}

void QHaccAccountBox::mousePressEvent( QMouseEvent * e ){ 
	popup->popup( e->globalPos() );
}

QHaccAccountBoxChooser * QHaccAccountBox::addTabAt( int idx,
																										const QString& text ){
	QHaccAccountBoxChooser * boxer=new QHaccAccountBoxChooser( engine, this );
	boxer->readPrefs( true );
	insertItem( idx, boxer, text );

	boxer->setAccount( chooser->getSelected() );

	// keep the the new list synchronized with the true chooser
	connect( chooser, SIGNAL( changedAccount( const Account& ) ),
					 boxer, SLOT( setAccount( const Account& ) ) );
	connect( boxer, SIGNAL( changedAccount( const Account& ) ),
					 chooser, SLOT( setAccount( const Account& ) ) );

	// make the popups work, too
	connect( boxer, SIGNAL( needRecWinOf( const Account& ) ),
					 this, SLOT( recwin( const Account& ) ) );
	connect( boxer, SIGNAL( needSubsetOf( const Account& ) ),
					 this, SLOT( subwin( const Account& ) ) );
	connect( boxer, SIGNAL( changedAccount( const Account& ) ),
					 this, SLOT( changed( const Account& ) ) );
	connect( boxer, SIGNAL( needReportOf( const Account& ) ),
					 this, SLOT( report( const Account& ) ) );
	connect( boxer, SIGNAL( needGraphOf( const Account& ) ),
					 this, SLOT( chart( const Account& ) ) );
	connect( boxer, SIGNAL( acctOrderChanged() ), SLOT( ssave() ) );

	save();
	return boxer;
}

void QHaccAccountBox::newTabAbove(){
	bool ok;
	QString text=QInputDialog::getText( i18n( "Add Tab Above" ),
																			i18n( "New tab name" ), QLineEdit::Normal,
																			i18n( "New Tab" ), &ok, this );
	if ( ok && !text.isEmpty() ) addTabAt( currentIndex(), text );
}

void QHaccAccountBox::newTabBelow(){
	bool ok;
	QString text=QInputDialog::getText( i18n( "Add Tab Below" ),
																			i18n( "New tab name" ), QLineEdit::Normal,
																			i18n( "New Tab" ), &ok, this );
	if ( ok && !text.isEmpty() ) addTabAt( currentIndex()+1, text );
}

void QHaccAccountBox::renameTab(){	
	int ind=currentIndex();
	bool ok;
	QString text=QInputDialog::getText( i18n( "Rename Tab" ),
																			i18n( "New tab name" ), QLineEdit::Normal,
																			itemLabel( ind ), &ok, this );
	if ( ok && !text.isEmpty() ) setItemLabel( ind, text );
}

void QHaccAccountBox::removeTab(){ removeItem( currentItem() ); }

void QHaccAccountBox::tabChanged( int i ){
	rem->setEnabled( item( i )!=chooser );
}

void QHaccAccountBox::dragEnterEvent( QDragEnterEvent * e ){
	if( QHaccADrag::canDecode( e ) ) e->accept();
}

void QHaccAccountBox::dropEvent( QDropEvent * e ){
	Account a;
	if( QHaccADrag::decode( e, a ) ){
		e->accept();
		QWidget * c=childAt( e->pos(), true );
		
		// figure out which tab we're dropping onto by the tab names
		if( c ){
			int cnt=count();
			for( int i=0; i<cnt; i++ ){
				if( itemLabel( i )==c->name() ){
					c=item( i );
					if( c!=chooser ){
						QHaccAccountBoxChooser * abc=( QHaccAccountBoxChooser * )c;
						abc->addAccount( a );
					}
				}
			}
		}
	}
}

