/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCTDLG_H
#define _QHACCACCTDLG_H

#include "qhacctablerows.h"

#include <qframe.h>
#include <qdialog.h>
#include <qtabdialog.h>

class QHacc;
class QLabel;
class MonCon;
class QString;
class QListBox;
class QSplitter;
class QComboBox;
class QCheckBox;
class QLineEdit;
class QCheckBox;
class QGridLayout;
class QPushButton;
class QButtonGroup;
class QRadioButton;
class QHaccLineEdit;
class QHaccDateEdit;
class QMultiLineEdit;
class QHaccChoiceEdit;
class AccountAreaFrame;

/********************************************/
/********* AccountEdit1 definitions *********/
/********************************************/

class AccountTab1 : public QWidget {
  Q_OBJECT
    public:
  AccountTab1( QHacc * engine, const Account&, bool fordefault, QWidget * =0,
							 const char * =0 );
  ~AccountTab1();

	void modify( Account& ) const;
	QButtonGroup * getTypeGroup() const;

 protected:
	QLineEdit * bal, * name, * number, * transtypes, * budget;
	QHaccChoiceEdit * parent, * dttype;
	QButtonGroup * typeBox;
	QCheckBox * taxed, * category;
	QHacc * engine;
	int loaner;

	public slots:
		void makeTTChoices();
};

/********************************************/
/********* AccountEdit2 definitions *********/
/********************************************/

class AccountTab2 : public QWidget {
  Q_OBJECT
    public:
  AccountTab2( QHacc *, const Account&, QWidget * =0, const char * =0 );
  ~AccountTab2();
	
	void modify( Account& ) const;

 protected:
	QFrame ** instinfo; // text widgets only
};

/********************************************/
/********* AccountEdit3 definitions *********/
/********************************************/

class AccountTab3 : public QWidget {
  Q_OBJECT
    public:
  AccountTab3( QHacc *, const Account&, QWidget * =0, const char * =0 );
  ~AccountTab3();
	
	void modify( Account& ) const;

 protected:
	QHacc * engine;
	QLineEdit * anint, * paysleft, * payment;
	QCheckBox * isloan;

	protected slots:
		void loaner( bool );
};

/********************************************************/
/*********  Account Create/Edit/Removal Dialog  *********/
/********************************************************/
class AccountDlg : public QTabDialog {
	Q_OBJECT
		public:
	AccountDlg( QHacc *, const Account& , QWidget * =0,
							const char * =0, bool =false );
	~AccountDlg();

	static void qremove( QHacc *, const Account&, QWidget * =0 );

	Account getAccount() const;

 protected:
	bool edit;
	QHacc * engine;
	Account account;
	AccountTab1 * tab1;
	AccountTab2 * tab2;
	AccountTab3 * tab3;

	void close();
	void accept();

	public slots:
		void typer( int );
};

#endif
